;08.01.24 keller entwssern
;PIC18F13K22/Assembler:MPASM V5.20/IDE: MPLABX v3.20
;
;        port a: a2,a4 eingnge, a0,a1,a3,a5 ausgnge 
;		    RA0 nur programmieren: PGD
;		    RA1 nur programmieren: PGC
;		    RA2 sensor oben
;		    RA3 nur programmieren: VPP
;		    RA4 sensor unter
;		    RA5 nc
;        port b: nur ausgnge
;		    RB4 na
;		    RB5 na
;		    RB6 na 
;		    RB7 pumpenrelais
;        port c: nur ausgnge
;		    RC4 kontroll-led
;                   RC5 kontroll-led
;                   alle anderen n.c.
;------------------------
#include <p18F13K22.inc>
    ;config settings
    CONFIG IESO = OFF, PLLEN = OFF, FOSC = IRC, FCMEN = OFF, PCLKEN = OFF
    CONFIG BOREN = OFF, BORV = 19, PWRTEN = OFF, WDTEN = OFF
    CONFIG MCLRE = OFF, HFOFST = OFF, DEBUG = OFF, STVREN = ON
    CONFIG XINST = OFF, BBSIZ = OFF, LVP = OFF

    errorlevel -302             ;surpress the 'not in bank0' warning
;--------------------------------
     Org    0x0000	
     bra    START
          
START:                  ;Setup main init
                        ;
     movlw  b'00000010' ;set cpu clock speed of 31KHz !!!!!!
     movwf  OSCCON      ;move contents of working register
     movlw  b'00000100' ;primary oszi einschalten
     movwf  OSCCON2     
     clrf   OSCTUNE,0   ;
     
     clrf   LATA,0
     movlw  b'00010100' ;port a2,a4 eingang, a0,a1,a3,a4 ausgang
     movwf  TRISA       ;
     clrf   WPUA        ;pull up disabled
     clrf   ANSEL       ;alle input pins auf digital
     bsf    IOCA,2      ;a2 fr port-change freigeben
                 
     clrf   LATB,0      ;init the latch
     clrf   TRISB       ;alles ausgang
               
     clrf   LATC,0      ;init the latch
     clrf   TRISC,0     ;alles als output
;-----------------------
test1:
sensu1:               ;sensor unten geschaltet?
     nop
     btfss  PORTA,4   ;wenn "1", dann kein wasser unten
     bra    pumpen    ;ist "0", also wasser da  
     nop              ;kein wasser da, also sleepen
;-------------------------    
Main:
     nop
schlafen:     
     clrf   LATB         ;pumpe aus
     movf   PORTA,0      ;read-memory-write, port a nur lesen
     clrf   INTCON
     bsf    INTCON,RABIE ;RABIE fr PortA/B-Change setzen
     sleep
     nop 
;-------------------
auf:
     movf   PORTA,0       ;read-memory-write, port a nur lesen
     bcf    INTCON,RABIF
     clrf   INTCON
;----
pumpen:
     nop 
     bsf    LATB,7    ;pumpen motor an
pump:
     nop
test3:
     btfss  PORTA,4   ;wenn "1", dann kein wasser unten
     bra    pump      ;in schleife pumpen bleiben, wie wasser an unterem
                      ;sensor ist
     bcf   LATB,7     ;kein wasser mehr an unterem sensor: pumpe stoppen
     nop
     bra    Main
     
     end
;-----------------------------------------