; File:     Main.ASM
; Author:   Ottmar
; Date:     2024.01.19
; Softw.:   MPLAB 8.92
;*********************************************************************
; Files:    Main.ASM
;           Include.INC          enthaelt hinzuzufuegende Subroutinenn
;           P18F14K22.INC        MCU-spezifische Labels (sie dort)
;           PIC18F1XK22/LF1XK22  Datasheet (DS) 
; fosc      31kHz                interner Oszillator
;*********************************************************************
; Projektbeschreibung
; -------------------
; Immer wieder gebrauchte Routinen in der Datei 'Include.INC' sollen
; im aktuellen ASM-File verwendet werden. Dies wird hier dargestellt.
;  
; Das Programm ist im "absolute code" - Modus erstellt (Modus kann
; in MPLAB 8.92 beim erstmaligen Speichern ausgewaehlt werden).

;*********************************************************************
;--SUPPRESSED WARNINGS
   ERRORLEVEL -302   ;Register in operand not in bank 0. Ensure ..
   ERRORLEVEL -207   ;Found label after column 1.
   ;
   LIST     P=18F14K22      ;list directive to define processor
   #INCLUDE <P18F14K22.INC> ;processor specific variable definitions
   ;
;--MCU-CONFIGURATION settings -> P18F14K22.INC 
    CONFIG IESO = OFF, PLLEN = OFF, FOSC = IRC, FCMEN = OFF, PCLKEN = OFF
    CONFIG BOREN = OFF, BORV = 19, PWRTEN = OFF, WDTEN = OFF
    CONFIG MCLRE = OFF, HFOFST = OFF, DEBUG = OFF, STVREN = ON
    CONFIG XINST = OFF, BBSIZ = OFF, LVP = OFF
    ;FOS=IRC -> fosc = 1MHz default nach reset vgl. DS 2.6.2 HFINTOSC
;*********************************************************************
;--MACROS
   INTOSC_31KHZ   MACRO    ;activates INTOSC 31kHz (default 1MHz)
   clrf     OSCCON         ;IDLEN=0->SLEEP mode, IRCF2:0=000->31kHz
   bsf      OSCCON,SCS1    ;b1:0=1x -> int.osc-block
   clrf     OSCCON2
   bsf      OSCCON2,PRI_SD ;b2=1 Oscillator drive circuit ON
   clrf     OSCTUNE        ;fosc 31,0kHz, factory calibrated
   ;bcf     OSCTUNE,INTSRC ;b7=0 31,0kHz device clock LFINTOSC
   ENDM
   ;
;*********************************************************************
;--VARIABLEN DEFINITIONEN (absolute code)
;*********************************************************************
   CBLOCK   0x20  ;auch Variable des INC-Files hier deklarieren
      d3,d2,d1,d0 ;Zaehlvariable in delays
      cntA        ;counter
      ACb1,ACb0   ;16Bit-Zahl HIGH-,LOW-byte
   ENDC
;*********************************************************************
   ORG      0x0000      ;processor reset vector
   GOTO     init
   ;
   ORG      0x0008      ;high priority interrupt vector (unused)
   RETFIE
   ;
   ORG      0x0018      ;low priority interrupt vector (unsused)
   RETFIE
;*********************************************************************
init:
   INTOSC_31KHZ      ;interner Oszillator aktiv f=31kHz
   ;                 ;muss nicht sein, hat mich halt interessiert
   clrf     PORTA    ;ein paar dummy-initialisierungen
   clrf     PORTB
   clrf     PORTC   
   clrf     INTCON
   ;
   GOTO  main
   ;hier koennte z.B. noch eine LUT (look up table) eingefuegt sein
;*********************************************************************
;  HAUPTPROGRAMM
;*********************************************************************
main:
   clrf     ACb1
   clrf     ACb0
   clrf     cntA
   ;
   CALL  Delay100ms     ;wartet 100ms (einfaches Delay-Beispiel)
   ;
; Division durch 2 wird n-mal ausgefhrt Teiler=2^n
; die zu dividierende Zahl steht in ACb1:0
;        das Ergebnis wird steht in ACb1:0             
; Beispielrechnung
; h2000 = 8192
; 8192/2=4096/2=2048/2=1024 (0x0400)
   movlw    0x20
   movwf    ACb1        ;16bit H-Byte
   movlw    0x00
   movwf    ACb0        ;16bit L-Byte
   movlw    .3          ;3x durch 2 teilen
   CALL     DIV_16bit2  ;Divisionen ausfuehren,Ergebnis in ACb1:0 
   ;
main_end:
   GOTO     main_end    ;Warteschleife
;*********************************************************************
;  SUBROUTINES
;*********************************************************************
; Im File ''Main.lst' kann nach dem Kompilieren der gesamte,
; zusammengefuegte Code angeschaut werden. Dieser Code ist dann auch
; im HEX-File enthalten. 
     #INCLUDE INCLUDE.INC    ;   DateiInclude
;*********************************************************************
   END
















