; File:     INCLUDE.INC
; Author:   Ottmar
; Date:     2024.01.19
; Info:     Inhalt kann in beliebige ASM-File eingefuegt werden
;           erforderlich ist lediglich, dass das Einfuegen mit
;           dieser Zeile erfolgt:
;           a) wenn die Datei sich im Programmordner befindet
;           #INCLUDE INCLUDE.INC 
;           b) wenn die Datei sich irgendwo auf dem PC befindet
;           #INCLUDE  Pfad/INCLUDE.INC
;*********************************************************************
; Files:    Include.INC    (
;           P18F14K22.INC  (MCU-spezifische Labels (sie dort)
;*********************************************************************
; Projektbeschreibung
; -------------------
; Immer wieder verwendete Routinen in der Dateie Include.INC sollen im
; aktuellen ASM-File verwendet werden. Dies wird hier dargestellt. 
; Zunaechst wird das Programm im "absolute code" - Modus erstellt
; indem das Projekt so bei ersten Mal gespeichert wird (Auswahlfenster
; absolute / relocatable code).
;*********************************************************************
Delay100ms:          ;call+return=  3 cycles
   movlw    .250  
   movwf     d1      ;2cycles
loop1:
   decfsz   d1,f
   GOTO     loop1    ;1x von loop1-GOTO = 3 Instruction cycles
   movlw    .8       ;250x3+2    = 752cycl
   movwf    d1
loop2:
   decfsz   d1,f     ;8x3+2      =  26 cycl   
   GOTO     loop2    ;gesamt     = 781 cycl
   RETURN            
  ;delay(ms)  =(1000ms/31000Hz*0,25) *4)] * 881 =100,77ms
  ;Arbeitstakt = fosc/4  z.B. movwf=1 instruction cycle             
;*********************************************************************
DIV_16bit2: 
; Aufruf    movlw    0x20
;           movwf    ACb1
; Aufruf:   movlw    0x00  Zahl welche 3x durch 2 geteilt wird
;           movwf    ACb0  Globale Variable, zum Aufruf der Sub
;           movlw    .3    3 mal ausfuehren: ACB1:0/2 ->0x400
;           CALL     DIV_16Bit2
;           Ergebnis in ACb1:0
;------------------------------
   movwf    cntA         ;Anzahl der Divisionen speichern
div2a:                 
   RRCF     ACb1,f      ;rotate right (f) no carry
   RRNCF    ACb0,f
   decfsz   cntA,f       ;fertig?
   GOTO     div2a        ;Z=0? nein? dann noch mal
   RETURN
;*********************************************************************
Unused_Sub_1:
   RETURN
Unused_Sub_2:
   RETURN
;*********************************************************************