;
; Software License Agreement
;
; The software supplied herewith by Microchip Technology Incorporated 
; (the Company) for its PICmicro Microcontroller is intended and 
; supplied to you, the Companys customer, for use solely and 
; exclusively on Microchip PICmicro Microcontroller products. The 
; software is owned by the Company and/or its supplier, and is 
; protected under applicable copyright laws. All rights are reserved. 
;  Any use in violation of the foregoing restrictions may subject the 
; user to criminal sanctions under applicable laws, as well as to 
; civil liability for the breach of the terms and conditions of this 
; license.  
;
; THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;************************************************************
;	PIC18CXX2 EXAMPLE CODE FOR PICDEM-2
;
;	TITLE: Oscillator Switching Demonstration
;	FILENAME: osc.asm
;	REVISION HISTORY:  A 5/13/00 jb   format change
;	HARDWARE: PICDEM-2 board
;	FREQUENCY: 4MHz
:
;************************************************************
; This program demonstrates the use of oscillator switching.
; 
; The data held in MYDAT is periodically flashed on the PORTB
; LEDs.  Each time a keypress is detected on RA4, the data is 
; incremented and the oscillator source is changed.

	list p=18c452, n=48, t=ON, st=OFF
	#include "p18c452.inc"
	
KEY		EQU   4	

;-------------------18C452 RAM LOCATIONS------------------------------


COUNT0		EQU      0x0000      ; used for software timing loop
COUNT1		EQU      0x0001      ;            "
MYDAT		EQU      0x0002      ; data storage register

;------------------BIT DEFINITIONS------------------------------------

F                 EQU      0x0001

;------------------VECTORS--------------------------------------------

ORG		0x000000	; reset vector
BRA		START

;--------------------PROGRAM-----------------------------------

START
   rcall    INIT		; setup ports, etc.
   bsf      T1CON, T1OSCEN	; setup the LP oscillator

MLOOP

   btfss    PORTA,KEY
   rcall    KEYPRESS		; call keypress routine if
 				; button is pressed
   movff    MYDAT,PORTB		; move data to portb
   rcall    WAIT		; wait a while
   clrf     PORTB		; clear the port
   rcall    WAIT		; wait a while
   
   bra      MLOOP

;-------------------------------SUBROUTINES---------------------------------

KEYPRESS

   btfss    PORTA,KEY
   bra      KEYPRESS
   incf     MYDAT

; Oscillator source changes every time the subroutine is called.

   btg      OSCCON,SCS
     
   return

INIT

   clrf     PORTA
   clrf     PORTB
   bsf      DDRA,4
   clrf     DDRB
   
   return

WAIT                                   ; software time delay
   clrf     COUNT0
   movlw    0x08
   movwf    COUNT1
WLOOP
   decfsz   COUNT0,F
   bra      WLOOP
   decfsz   COUNT1,F
   bra      WLOOP
      
   return

	end	
