; PICkit 3 Starter Kit
; Assembly Lesson 4 - "Analog to Digital"
;
; This shows how to read the A2D converter and display the
; High order parts on the 4 bit LED display.
; The pot on the Low Pin Count Demo board varies the voltage
; coming in on in A0.
;
; The A2D is referenced to the same Vdd as the device, which
; is nominally is 5V.  The A2D returns the ratio of the voltage
; on Pin RA0 to 5V.  The A2D has a resolution of 10 bits, with 1024 
; representing 5V and 0 representing 0V.
;
;
; The top four MSbs of the ADC are mirrored onto the LEDs. Rotate the potentiometer
; to change the display.
;
; VSK @THU 22.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>

    ; -------------------LATC-----------------
    ; Bit#:  -7---6---5---4---3---2---1---0---
    ; LED:   ---------------|DS4|DS3|DS2|DS1|-
    ; ----------------------------------------

PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:                       ;Setup main init
    BANKSEL     OSCCON          ;bank1
    movlw       00111000B       ;set cpu clock speed
    movwf       OSCCON          ;move contents of the working register into OSCCON

                                ;Configure the ADC/Potentimator
                                ;already in bank1
    bsf         TRISA, 4        ;Potentimator is connected to RA4....set as input
    movlw       00001101B       ;select RA4 as source of ADC and enable the module (carefull, this is actually AN3)
    movwf       ADCON0
    movlw       00010000B       ;left justified - Fosc/8 speed - vref is Vdd
    movwf       ADCON1
    BANKSEL     ANSELA          ;bank3
    bsf         ANSELA, 4       ;analog for ADC

                                ;Configure the LEDs
    BANKSEL     TRISC           ;bank1
    clrf        TRISC           ;make all of PORTC an output
    BANKSEL     LATC            ;select the bank where LATC is
    movlw       00001000B       ;start the rotation by setting DS1 ON
    movwf       LATC            ;write contents of the working register to the latch
MainLoop:
                                ;Start the ADC
    nop                         ;requried ADC delay of 8uS => (1/(Fosc/4)) = (1/(500KHz/4)) = 8uS
    banksel     ADCON0
    bsf         ADGO            ;start the ADC
    btfsc       ADGO            ;this bit will be cleared when the conversion is complete
    goto        $-1             ;keep checking the above line until GO bit is clear

                                ;Grab Results and write to the LEDs
    swapf       ADRESH, w       ;Get the top 4 MSbs (remember that the ADC result is LEFT justified!)
    banksel     LATC
    movwf       LATC            ;move into the LEDs
    bra         MainLoop

    END     resetVec