; PICkit 3 Starter Kit
; Assembly Lesson 5 "Variable Speed Rotate"
;    
; This lesson combines all of the previous lessons to produce a variable speed rotating
; LED display that is proportional to the ADC value. The ADC value and LED rotate
; speed are inversely proportional to each other.
;
; Rotate the POT counterclockwise to see the LEDs shift faster.
    
    
; VSK @THU 23.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>
    
GLOBAL Delay1,Delay2;make them global -> watchable when debugging
PSECT udata_shr     ;shared memory location that is accessible from all banks
Delay1:
    DS      1       ;reserve 1 byte for Delay1
Delay2:
    DS      1       ;reserve 1 byte for Delay2

    ; -------------------LATC-----------------
    ; Bit#:  -7---6---5---4---3---2---1---0---
    ; LED:   ---------------|DS4|DS3|DS2|DS1|-
    ; ----------------------------------------

PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:                       ;Setup main init
    BANKSEL     OSCCON          ;bank1
    movlw       00111000B       ;set cpu clock speed
    movwf       OSCCON          ;move contents of the working register into OSCCON

                                ;Configure the ADC/Potentimator
                                ;already in bank1
    bsf         TRISA, 4        ;Potentimator is connected to RA4....set as input
    movlw       00001101B       ;select RA4 as source of ADC and enable the module (carefull, this is actually AN3)
    movwf       ADCON0
    movlw       00010000B       ;left justified - Fosc/8 speed - vref is Vdd
    movwf       ADCON1
    BANKSEL     ANSELA          ;bank3
    bsf         ANSELA, 4       ;analog for ADC

                                ;Configure the LEDs;bank1
    BANKSEL     TRISC           ;bank1
    clrf        TRISC           ;make all of PORTC an output
    BANKSEL     LATC            ;select the bank where LATC is
    movlw       00001000B       ;start the rotation by setting DS1 ON
    movwf       LATC            ;write contents of the working register to the latch
MainLoop:
    call        A2d             ;get the ADC result
                                ;top 8 MSbs are now in the working register (Wreg)
    movwf       Delay2          ;move ADC result into the outer delay loop
    call        CheckIfZero     ;if ADC result is zero, load in a value of '1' or else the delay loop will decrement starting at 255
    call        DelayLoop       ;delay the next LED from turning ON
    call        Rotate          ;rotate the LEDs

    bra         MainLoop        ;do this forever

CheckIfZero:
    movlw       0               ;load wreg with '0'
    xorwf       Delay2, w       ;XOR wreg with the ADC result and save in wreg
    btfss       ZERO            ;if the ADC result is NOT '0', then simply return to MainLoop
    return                      ;return to MainLoop
    movlw       1               ;ADC result IS '0'. Load delay routine with a '1' to avoid decrementing a rollover value of 255
    movwf       Delay2          ;move it into the delay location in shared memory (RAM)
    return                      ;return to MainLoop

A2d:                            ;Start the ADC
    nop                         ;requried ADC delay of 8uS => (1/(Fosc/4)) = (1/(500KHz/4)) = 8uS
    banksel     ADCON0
    bsf         ADGO            ;start the ADC
    btfsc       ADGO            ;this bit will be cleared when the conversion is complete
    goto        $-1             ;keep checking the above line until GO bit is clear
    movf        ADRESH, w       ;Get the top 8 MSbs (remember that the ADC result is LEFT justified!)
    return

DelayLoop:                      ;Delay amount is determined by the value of the ADC
    decfsz      Delay1,f        ;will always be decrementing 255 here
    goto        DelayLoop       ;The Inner loop takes 3 instructions per loop * 255 loops (required delay)
    decfsz      Delay2,f        ;The outer loop takes and additional 3 instructions per lap * X loops (X = top 8 MSbs from ADC conversion)
    goto        DelayLoop
    return

Rotate:
    banksel     LATC            ;change to Bank2
    lsrf        LATC            ;logical shift right
    btfsc       CARRY           ;did the bit rotate into the carry?
    bsf         LATC,3          ;yes, put it into bit 3.
    return

    END     resetVec