;umbauversuch 02 von pic10f200 auf pic18f14k22 und xc8-assembler
; CircuitBread Tutorials
; Microcontroller Basics (PIC10F200), Part 6 - How to Blink a LED
; Blink both LEDs.
; Source code conversion from Microchip MPASM to Microchip XC8 PIC Assembler.

; Include target device specific definitions.
#include <xc.inc>

; Some equates not included in the device specific definitions.
T0CS	EQU 0005h
    
; Set the configuration word.
CONFIG WDTE = OFF       ; Watchdog Timer (WDT disabled)
CONFIG CP = OFF         ; Code Protect (Code protection off)
CONFIG MCLRE = OFF      ; Master Clear Enable (MCLR disabled, GP3 enabled)

; NOTE: To make sure the PIC10F200 RC oscillator calibration instruction at
; the 0xFF program memory address is not overwriten place this psect elsewhere
; , for example at the program memory start address: Project Properties >
; pic-as Global Options > Additional Options: -Wl,-pMyCode=0h
    PSECT MyCode,class=CODE,delta=2
INIT:
    MOVLW ~(1 << T0CS)  ;Enable GPIO2
    OPTION
    MOVLW ~((1 << GPIO_GP2_POSITION) | (1 << GPIO_GP1_POSITION))  ;Set GP1 and GP2 as outputs
    TRIS GPIO
LOOP:
    BSF GPIO, GPIO_GP2_POSITION      ;Set GP2
    NOP             ;No operation
    BCF GPIO, GPIO_GP1_POSITION      ;Reset GP1
    CALL DELAY      ;Call DELAY subroutine
    BCF GPIO, GPIO_GP2_POSITION      ;Reset GP2
    NOP             ;No operation
    BSF GPIO, GPIO_GP1_POSITION      ;Set GP1
    CALL DELAY      ;Call DELAY subroutine
    GOTO LOOP       ;loop forever
 
DELAY:              ;Start DELAY subroutine here
    MOVLW 05h       ;Load initial value for the delay    
    MOVWF 010h      ;Copy the value to the register 0x10
    MOVWF 011h      ;Copy the value to the register 0x11
    MOVWF 012h      ;Copy the value to the register 0x12
DELAY_LOOP:         ;Start delay loop
    DECFSZ 010h, F  ;Decrement the register 0x10 and check if not zero
    GOTO DELAY_LOOP ;If not then go to the DELAY_LOOP label
    DECFSZ 011h, F  ;Else decrement the register 0x11, check if it is not 0
    GOTO DELAY_LOOP ;If not then go to the DELAY_LOOP label
    DECFSZ 012h, F  ;Else decrement the register 0x12, check if it is not 0
    GOTO DELAY_LOOP ;If not then go to the DELAY_LOOP label
    RETLW 0         ;Else return from the subroutine

    END INIT	    ; Program entry point.