; PICkit 3 Starter Kit
; Assembly Lesson 2 - "Blink"
;
; VSK @THU 21.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_18F14K22.s
#include <xc.inc>

GLOBAL Delay1,Delay2;make this global so it is watchable when debugging
PSECT udata_acs     ;access memory location
Delay1:
    DS      1       ;reserve 1 byte for Delay1
Delay2:
    DS      1       ;reserve 1 byte for Delay2

    ; -------------------LATC-----------------
    ; Bit#:  -7---6---5---4---3---2---1---0---
    ; LED:   ---------------|DS4|DS3|DS2|DS1|-
    ; ----------------------------------------

PSECT resetVec,class=CODE,reloc=2   ; define "-presetVec=0h" in custom linker options
resetVec:
    movlw   00101000B   ;set cpu clock speed of 500KHz ->correlates to (1/(500K/4)) for each instruction
    movwf   OSCCON,A
    bcf     TRISC,0,A   ; make IO Pin C0 an output
    clrf    LATC,A      ; init the LATCH by turning off everything

MainLoop:
    decfsz  Delay1,f,A  ; Waste time.
    bra     MainLoop    ;The Inner loop takes 3 instructions per loop * 256 loops = 768 instructions
    decfsz  Delay2,f,A  ;The outer loop takes an additional 3 instructions per lap * 256 loops
    bra     MainLoop    ;(768+3) * 256 = 197376 instructions / 125K instructions per second = 1.579 sec.
    btg     LATC,0,A    ;toggle DS1
    bra     MainLoop    ;do this forever

    END     resetVec
