;25.10.2024 lcd09    
;umschreiben von sprut lcd.asm auf diese mplab x version
;anweisung: PORTB ersetzen durch LATC ; write to port auf latch
;.............
;PIC: 18F13K22//Assembler:MPASM V5.84//IDE: MPLABX v5.20
;
;Port A:    ausgang,n.c.
;Port B:    ausgang,n.c.
;Port C:    c0: Displ Enable c1:nc c2: reg select c3: read/write
;           c4 bis c7 daten D4 .. D7         
;-----------------------------------------------------------------------------
#include <p18F13K22.inc>

;Config settings
          CONFIG IESO = OFF, PLLEN = OFF, FOSC = IRC, FCMEN = OFF, PCLKEN = OFF
          CONFIG BOREN = OFF, BORV = 19, PWRTEN = OFF, WDTEN = OFF
          CONFIG MCLRE = ON, HFOFST = OFF, DEBUG = OFF, STVREN = ON
          CONFIG XINST = OFF, BBSIZ = OFF, LVP = OFF

          errorlevel -302        ;surpress the 'not in bank0' warning
 
GPR_VAR   UDATA
LcdDaten  RES  1
LcdStatus RES  1
counta    RES  1
counti    RES  1
;----------------
;ehemalige Constanten
;LcdE    equ     0       ; enable Lcd
;LcdRw   equ     3       ; read Lcd
;LcdRs   equ     2       ; Daten Lcd (nicht control)	
;.....................................................................
     Org    0x0000           ;kein reset vector     bra    START

START:                       ;Setup main init
     movlw      b'00000010'  ;set cpu clock speed of 31KHz
     movwf      OSCCON       ;move contents of working register into OSCCON
     clrf       OSCTUNE      ;
          
     clrf       LATA         ;port a auf ausgang
     clrf       TRISA
     clrf       LATB         ;init the latch
     clrf       TRISB
     clrf       LATC         ;init the latch by turning off everything
     clrf       TRISC        ;
     clrf       ANSEL
     clrf       ANSELH       ;bei portc keine wake-up-r's vorhanden
;-----------------------------------------------------------------------------
MainLoop:                    ;beginn hauptprogramm
Init:	
        nop
        call	InitLCD      ; Display initialisieren
;------------
textaus:                     ; Text am LCD ausgeben
	movlw	'D'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'a'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'n'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'k'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'e'
	movwf	LcdDaten
	call	OutLcdDaten
        movlw	'-'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'P'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'i'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'c'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'c'
	movwf	LcdDaten	
        call	OutLcdDaten
	movlw	'e'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'r'
	movwf	LcdDaten
	call	OutLcdDaten
Main:                         ;eine datenausgabe fertig,				
	goto 	Main          ;jetzt hier warten
;---------------------------	
InitLCD:                      ; Initialisierung des LCD-Displays
Init1:	movlw	d'100'        ; 250 ms Pause nach dem Einschalten
	movwf	counta	
	call	butak		

	movlw	b'00110000'   ; 1
	movwf	LATC
	bsf	LATC,0        ;lcd enable
	nop	
	bcf	LATC,0
	
	movlw	d'20'         ; 50 ms Pause
	movwf	counta
	call	butak
	
	movlw	b'00110000'   ; 2
	call	Control8Bit
	movlw	b'00110000'   ; 3
	call 	Control8Bit
	movlw	b'00100000'   ; 4
	call 	Control8Bit

	movlw	b'00000001'   ; lschen und cusor home
	call	OutLcdControl	
	movlw	b'00101000'   ; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	b'00001000'   ; 6 display off
	call	OutLcdControl
	movlw	b'00000110'   ; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	b'00000011'   ; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	b'00001111'   ; 9 display on
	call	OutLcdControl
	return
;------------------------
Control8Bit:                  ;ein Steuerbyte 8-bittig bertragen
Init2:	movwf	LATC
	bsf	LATC,0        ;lcd enable
	nop
	bcf	LATC,0
	movlw	d'4'        
	movwf	counta        ;pause 10 ms
	call 	butak
	return
;----------------------------
OutLcdControl:                ;ein Byte Steuerdaten von LcdDaten bertragen
Init3:	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten,0
	andlw	h'f0'
	movwf	LATC          ;Hi-teil Daten schreiben
	bsf	LATC,0
	nop
	bcf	LATC,0        ;Disable LcdBus
	swapf	LcdDaten,0
	andlw	h'f0'
	movwf	LATC          ;Lo-teil Daten schreiben
	bsf	LATC,0
	nop
	bcf	LATC,0        ;Disable LcdBus
	return
;-----------------------------
LcdBusy:                      ;warten,bis Display bereit zur Datenannahme ist
daten1:	movlw	b'11110000'
	iorwf   TRISC,1 
BusyLoop:		
	bcf	LATC,2
	bsf	LATC,3        ;
	bsf	LATC,0       
	nop
	movf	PORTC,0       ;hier lesen !!!!
	movwf	LcdStatus
	bcf	LATC,0
	nop
	bsf	LATC,0        ;Enable
	nop
	bcf	LATC,0
	btfsc	LcdStatus,7   ;teste bit 7
	goto	BusyLoop
	bcf	LATC,3
	movlw	b'00001111'
	andwf   TRISC,1    
	return	
;------------------------------
OutLcdDaten:                  ;ein Datenbyte LCDDaten zum Display bertragen
daten2:	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten,0
	andlw	h'f0'
	movwf	LATC          ;Hi-teil Daten schreiben
	bsf	LATC,2        ;Daten
	bsf	LATC,0        ;Enable LcdBus
	nop
	bcf	LATC,0        ;Disable LcdBus	
	swapf	LcdDaten,0
	andlw	h'f0'
	movwf	LATC          ;Lo-teil Daten schreiben
	bsf	LATC,2        ;Daten
	bsf	LATC,0
	nop
	bcf	LATC,0        ;Disable LcdBus	
	bcf	LATC,2	    
	return
;----------------------------------------
butak:                        ;Zeitverzgerung, je nach conta-befllung: 
        nop                   ;250 / 50 / 10 ms
        nop
        nop
loopa:
        movlw   d'5'          ;1
        movwf   counti        ;1  ;innere loop mit 5 dez
loopi:
        decfsz  counti,1      ;1(2)
        bra     loopi         ;2
        decfsz  counta,1      ;1(2)
        bra     loopa         ;2
        return                ;2

	end		  
;-----------------------------------------------------------------------------
