#include "hardware.h"
#include "hardware2.h"
#include "inttypes.h"

//platine_keine //ursprngliche Hardwareeinstellungen auer DS18b22
//platine4028 //4028vorhanden
//platine_nur373// 4028 berbrckt C0 lcd_e0, c1 lcd_e1 c2 373_le

 extern uint8_t d373_alt;
 extern uint8_t d373_akt;

 void u373Bset(uint8_t d373_1){
    d373_akt |= d373_1; //Bit setzen mit Maske
    u373(d373_akt);
}

void u373Bclr(uint8_t d373_1){
    d373_1 =~d373_1;
    d373_akt &= d373_1; //Bit lschen mit Maske
    u373(d373_akt);
}

 #if defined(platine4028)
void init_hard2(void){
    TRISC &= 0xfc;  //0..1 auf Ausgabe
    TRISD = 0;
    u4028(rU4028);
    d373_akt =0x2b;
    u373(d373_akt);    //LCD_RS (1) =1 LCD_RW (2) =1 EEProm_!CS (8) =1 r23s17 =1
}
void u4028(uint8_t sel4028){
    uint8_t lc;
    sel4028 &= 0x03;    //zur sicherheit nur 2 Bit
    lc = (LATC&0xfc)|sel4028;
    LATC =lc;
    wait_1us(5);
    //LATC= (LATC&0xfc)|sel4028;
}

void u373(uint8_t d373){
    uint8_t mr_tris;

    mr_tris = TRISD; // tris sichern
    d373_alt = d373_akt;
    TRISD =0;
    LATD = d373;
    wait_1us(5);
    u4028(U373_LE);
    d373_akt = d373;  //hier damit pause /Strobe
    u4028(rU4028);
   TRISD = mr_tris; // tris zurckschreiben
}
#endif

#if defined(platine_nur373)
void init_hard2(void){
    U373_LE_LAT = 0;    
    U373_LE_TRIS = 0; //Ausgabe

    d373_akt =3;
    u373(d373_akt);    //LCD_RS LCD_RW =1
}
void u373(uint8_t d373){
    uint8_t mr_tris;

    mr_tris = TRISD; // tris sichern
    d373_alt = d373_akt;
//    INTCONbits.GIEH=0;   //interrupt ausschalten
    TRISD =0;
    LATD = d373;
    wait_1us(1);
    U373_LE_LAT = 1;
    d373_akt = d373;  //hier damit pause /Strobe
    U373_LE_LAT = 0;
 //   wait_1us(5);
    TRISD = mr_tris; // tris zurckschreiben
//   INTCONbits.GIEH=1;   //interrupt ein
}

#endif

