#include "mcp23s17.h"

void u23s17_wr(uint8_t adr, uint8_t value){
	u23s17_sel();
	SpiWriteByte(ctrl_byte_wr);
    SpiWriteByte(adr);
    SpiWriteByte(value);
	u23s17_desel();
}

uint8_t u23s17_rd(uint8_t adr){
    uint8_t nByte;
	u23s17_sel();
	SpiWriteByte(ctrl_byte_rd);
	SpiWriteByte(adr);
	nByte = ReadSPI();
	u23s17_desel();
	return nByte;
}

void u23s17_init(void){
    SpiInit( SPI_FOSC_4 );  // in main.c unter Ethernet schon definiert
    //u23s17_wr(IOCON, 0x00);     //contr Register 
    u23s17_wr(IODIRA, 0x00);    //Ausgabe
    u23s17_wr(IODIRB, 0xff);    //Eingabe
    u23s17_wr(GPPUB, 0x00);    //pull up
    u23s17_wr(OLATA, 0x00);     //Ausgabe setzen
    //nByte = u23s17_rd(GPIOB)  //Port auslesen
}
	