#include "spieeprom.h"

/*
union _eeStatus{
	uint8_t _EEStatus;
	struct {
		unsigned WIP:1;
		unsigned WEL:1;
		unsigned BP0:1;
		unsigned BP1:1;
		unsigned :1;
		unsigned :1;
		unsigned WPEN:1;
	};
}EEStatus;
*/

/*
void EepromInit() {
	SpiInit();
	u25LC1024_desel();
}
*/

EEStatus_t EReadStatus(void) {
    EEStatus_t EEStatus;
	u25LC1024_sel();
	SpiWriteByte(u25_RDSR);
	EEStatus._EEStatus = SpiReadByte();
	u25LC1024_desel();
	return EEStatus;	//._EEStatus;
}

/*
unsigned u25_busy(void) {

	//uint8_t status;
	EEStatus._EEStatus = EReadStatus();
//	return status & 1;	//WIP
	return EEStatus.WIP;
}
*/

uint8_t EReadCh (uint32_t addr) {
	uint8_t c;
	// Send READ command and addr, then read data
	u25LC1024_sel();
	SpiWriteByte(u25_READ);
	// Address in 3x8 bit mode for 25lc1024
	SpiWriteByte((uint8_t)addr>>16);
	SpiWriteByte((uint8_t)addr>>8);
	SpiWriteByte((uint8_t)addr);
	c = ReadSPI();
	u25LC1024_desel();
	return c;
}


void EWriteCh (uint32_t addr, uint8_t data) {
	// Enable Write Latch
	u25LC1024_sel();
	SpiWriteByte(u25_WREN);
	u25LC1024_desel();

	// Send WRITE command, addr and data
	u25LC1024_sel();
	SpiWriteByte(u25_WRITE);
	SpiWriteByte((uint8_t)addr>>16);
	SpiWriteByte((uint8_t)addr>>8);
	SpiWriteByte((uint8_t)addr);
	SpiWriteByte(data);
	u25LC1024_desel();
}

void EReadBuff (uint32_t addr, uint8_t *data, uint16_t lenght) {
	unsigned int i;
	// Send READ command and addr, then read data
	u25LC1024_sel();
	SpiWriteByte(u25_READ);
	SpiWriteByte((uint8_t)addr>>16);
	SpiWriteByte((uint8_t)addr>>8);
	SpiWriteByte((uint8_t) addr);
	for(i = 0; i < lenght; ++i)
	data[i] = ReadSPI();
	u25LC1024_desel();
}

void EWriteBuff (uint32_t addr, uint8_t *data, uint16_t lenght) {
	uint8_t i;
	unsigned int begin = 0;
	unsigned int end = lenght > PSIZE ? PSIZE : lenght;
	while (end > begin && addr + end <= MLIMIT) {  // check if addr is a siutable address [0, MLIMIT]
		// Enable Write Latch
		u25LC1024_sel();
		SpiWriteByte(u25_WREN);
		u25LC1024_desel();

		// Send WRITE command, addr and data
		u25LC1024_sel();
		SpiWriteByte(u25_WRITE);
		SpiWriteByte((uint8_t)addr>>16);	//eingef gt
		SpiWriteByte((uint8_t)addr>>8);
		SpiWriteByte((uint8_t) addr);
		for(i = begin; i < end; ++i)
		SpiWriteByte(data[i]);
		u25LC1024_desel();
		while(EReadStatus().EEP_WIP);
		lenght -= PSIZE;
		begin += PSIZE;
		addr += PSIZE;
		end = begin + (lenght > PSIZE ? PSIZE : lenght);
}
