#ifndef spieeprom_H
#define spieeprom_H

#include "hardware.h"
#include "inttypes.h"
#include "SpiPort.h"
#include "hardware2.h"

//#define EEPROM_BUFFER_SIZE              32	//?

// Page byte size, 64 for 25lc256 and 256 for 25lc1024
#define PSIZE 256
// Addr mem limit 7FFF for 25lc256, 1FFFF for 25lc1024
#define MLIMIT 0x1FFFF

/*
TABLE 3-2: STATUS REGISTER S12 
		7    6    5    4    3    2    1    0
		W/R	             W/R  W/R  R    R
		WPEN X    X    X    BP1  BP0  WEL  WIP
		
WIP		(Busy) = beschftigt
WEL		Write Enable Latch 1= Schreiben erlaubt
WPEN	/WP Pin3 enable

BP1	BP0	Array Addresses Write-Protected
0	0	none
0	1	Upper 1/4	(Sector 3)		(18000h-1FFFFh)
1	0	Upper 1/2	(Sectors 2 & 3)	(10000h-1FFFFh)
1	1	All			(Sectors 0 - 3)	(00000h-1FFFFh) 
*/

typedef union _eeStatus {
	uint8_t _EEStatus;
	struct {
        unsigned EEP_WIP:1;
		unsigned EEP_WEL:1;
		unsigned EEP_BP0:1;
		unsigned EEP_BP1:1; 
        unsigned :1;
		unsigned :1;
		unsigned :1;
		unsigned EEP_WPEN:1;
	};
	struct {
        unsigned EEP_WIP:1;
		unsigned EEP_WEL:1;
		unsigned EEP_BP:2;
        unsigned :1;
		unsigned :1;
		unsigned :1;
		unsigned EEP_WPEN:1;
	};
} EEStatus_t;


// EEPROM SPI opcodes	S7
#define u25_READ    0x03    // Read data from memory array beginning at selected address
#define u25_WRITE   0x02    // Write data to memory array beginning at selected address
#define u25_WRDI    0x04    // Reset the write enable latch (disable write operations)
#define u25_WREN    0x06    // Set the write enable latch (enable write operations)
#define u25_RDSR    0x05    // Read Status register
#define u25_WRSR    0x01    // Write Status register
/*
#define u25_PE		0x42	// 0100 0010 Page Erase  erase one page in memory array
#define u25_SE		0xd8	// 1101 1000 Sector Erase  erase one sector in memory array
#define u25_CE		0xc7	// 1100 0111 Chip Erase  erase all sectors in memory array
#define u25_RDID	0xab	// 1010 1011 Release from Deep power-down and read electronic signature
#define u25_DPD		0xb9	// 1011 1001 Deep Power-Down mode
*/


#define u25LC1024_sel()  u373Bclr(r25LC_CS ); Nop()
#define u25LC1024_desel()  u373Bset(r25LC_CS ); Nop()


EEStatus_t EReadStatus(void);
uint8_t EReadCh (uint32_t addr);
void EWriteCh (uint32_t addr, uint8_t data);
void EReadBuff (uint32_t addr, uint8_t *data, uint16_t lenght);
void EWriteBuff (uint32_t addr, uint8_t *data, uint16_t lenght);

#endif	// spieeprom_H