/* 
 * File:   uCQ_2013_main.c
 * Author: VSK THU
 *
 * Created on 28. June 2019, 14:29
 */

#include "global_def.h"
#include "uCQuick/uCQ_2013.h"
#include "PLIB/plib18fxxk22.h"
#include "LCD/LCD_lib_busy.h"

#pragma warning disable  373    // implicit signed to unsigned conversion


//--- G L O B A L  V A R I A B L E S -------------------------------------------
unsigned short adc_value;
union DemoFlags flags;

//--- P R I V A T E  V A R I A B L E S -----------------------------------------
unsigned short frequency = 250;

//--- P R I V A T E   P R O T O T Y P E S --------------------------------------
void __init(void);

/*******************************************************************************
 ******************************************************************************/
void main(void)
{
    __init();

     while(1) {
    //----------------------------------------------------- check buttons & LEDs
        while (mGET_ENC_BTN()) {
            BTN_L_TRI = INPUT_PIN; __delay_us(10);
            if (mGET_BTN_L()) {
                while (mGET_BTN_L()) {;}
                mTOG_LED_1();
                mTOG_LED_2();
            }
            LED_1_TRI = OUTPUT_PIN;

            BTN_R_TRI = INPUT_PIN; __delay_us(10);
            if (mGET_BTN_R()) {
                while (mGET_BTN_R()) {;}
                mTOG_LED_3();
                mTOG_LED_4();
            }
            LED_3_TRI = OUTPUT_PIN;
        }
    //------------------------------------------------------ check encoder & PWM
        if(flags.encUp){
            if(frequency < 800) {frequency = frequency + 10;}
              else {frequency = frequency + 100;}
            if(frequency > 15600){frequency = 15600;}
            PR2 = (62500 / frequency) -1;   // 1MHz : 16
            CCPR1L = PR2 >> 1;
            LCD_ConstTextOut(1,4,"    ");   // wipe old value
            LCD_ValueOut(1,4,frequency);
            flags.encUp = 0;
        }
        if(flags.encDown){
            if(frequency < 800) {frequency = frequency - 10;}
              else {frequency = frequency - 100;}
            if(frequency < 250) {frequency  = 250;}
            PR2 = (62500 / frequency)-1;    // 1MHz : 16
            CCPR1L = PR2 >> 1;
            LCD_ConstTextOut(1,4,"    ");   // wipe old value
            LCD_ValueOut(1,4,frequency);
            flags.encDown = 0;
        }
    //---------------------------------------------------------------- check ADC
        if(flags.newADC){
            LCD_ConstTextOut(0,4,"    ");   // wipe old value
            LCD_ValueOut(0,4,ADRES);
            flags.newADC = 0;
        }
    //-------------------------------------------------------------- check USART
        if(DataRdy1USART()){
            TXREG1 = RCREG1 + 1;            // 'a' -> 'b' ...
        }
    }// while(1){
}

/*******************************************************************************
 ******************************************************************************/
void __init(void)
{
    OSCCONbits.IRCF = IRCF_4MHZ; OSCTUNEbits.PLLEN = 0;     // -> 4MHz

    LCD_Init();
    LCD_ConstTextOut(0,0,"MCON-LAB");
    LCD_ConstTextOut(1,0,"  THU   ");

    mALL_LED_OUTPUT();

// encoder and buttons setup ---------------------------------------------------------------
    ENC_INT_TRI = ENC_DIR_TRI = ENC_BTN_TRI = INPUT_PIN;
    ENC_INT_ANS = ENC_DIR_ANS = ENC_BTN_ANS = DIGITAL_PIN;

    mENC_IR_RST();
    mENC_IR_EN();

    BTN_L_TRI = BTN_R_TRI = INPUT_PIN;
    BTN_L_ANS = BTN_R_ANS = DIGITAL_PIN;

//PWM --------------------------------------------------------------------------
    CCP1CONbits.CCP1M = 0b1100;                             // PWM mode
    CCP1CONbits.P1M = 0;                                    // single
    CCPTMRS0bits.C1TSEL = 0;                                // CCP1-TMR2
    OpenTimer2(TIMER_INT_OFF & T2_PS_1_16 & T2_POST_1_1);
    PR2 = 62500 / frequency;                                // 1MHz:16
    CCPR1L = PR2 >> 1;
    SPEAKER_TRI = OUTPUT_PIN;

//ADC --------------------------------------------------------------------------
    POTI_TRI = INPUT_PIN; POTI_ANS = ANALOG_PIN;

    OpenADC(ADC_FOSC_8 & ADC_RIGHT_JUST & ADC_12_TAD,
            ADC_POTI & ADC_INT_ON,
            ADC_TRIG_CCP5 & ADC_REF_VDD_VDD & ADC_REF_VDD_VSS);

    OpenTimer5(TIMER_INT_OFF & T5_16BIT_RW & T5_SOURCE_FOSC_4 &
               T5_PS_1_2 & T5_OSC1EN_OFF & T5_SYNC_EXT_OFF,
               TIMER_GATE_OFF);

    CCPTMRS1bits.C5TSEL  = 2;   // timer <-> ccp module (CCP5 / TMR5)
    CCPR5 = 50000;              // Fosc/4 / prescaler / Fadc = 1MHz /2 /10Hz
    CCP5CONbits.CCP5M = 0b1011; // Compare Mode with Special Event Trigger

//USART ------------------------------------------------------------------------
    TX_TRI = RX_TRI = INPUT_PIN; RX_ANS = DIGITAL_PIN;

//#define SPBRG_VAL (((_XTAL_FREQ/BAUDRATE)+32)/64)-1     // BRG16=0, BGH=0 !
//#define SPBRG_VAL (((_XTAL_FREQ/BAUDRATE)+8)/16)-1      // BRG16=0, BGH=1 !
#define SPBRG_VAL (((_XTAL_FREQ/BAUDRATE)+2)/4)-1       // BRG16=1, BGH=1 !

    baud1USART(BAUD_IDLE_RX_PIN_STATE_HIGH &
                 BAUD_IDLE_TX_PIN_STATE_HIGH &
                 BAUD_16_BIT_RATE &
                 BAUD_WAKEUP_OFF &
                 BAUD_AUTO_OFF);

    Open1USART( USART_TX_INT_OFF & USART_RX_INT_OFF &
                USART_ASYNCH_MODE & USART_EIGHT_BIT &
                USART_CONT_RX &
                USART_BRGH_HIGH & USART_ADDEN_OFF,
                SPBRG_VAL );

    while(!mGET_ENC_BTN()){
        if(DataRdy1USART()){TXREG1 = RCREG1 + 1;}
    }
    LCD_ConstTextOut(0,0,"ADC ??? ");
    LCD_ConstTextOut(1,0,"PWM ??? ");

    flags.all = 0;
    INTCONbits.PEIE = 1;    // peripheral interrupt enable
    INTCONbits.GIE = 1;     // global interrupt enable
}
