/* 
 * File:                global_def.h
 * Author:              VSK THU
 * Comments:            globaly used stuff for uCQ test projects
 * Revision history:    
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef GLOBAL_DEF_H
#define	GLOBAL_DEF_H

#define _XTAL_FREQ  4000000
#define BAUDRATE    19200

//#include <xc.h>
#include "uCQuick/uCQ_2013.h"

union DemoFlags{
    char all;

    struct {
        unsigned LN : 4;
        unsigned HN : 4;
    };

    struct {
        unsigned encUp      : 1;
        unsigned encDown    : 1;
        unsigned bit2_3     : 2;
//        unsigned encCERR    : 1;    // code error
//        unsigned encOERR    : 1;    // overflow error
        unsigned newADC     : 1;
        unsigned bit5_7     : 3;
//        unsigned newCapture : 1;
//        unsigned newSec     : 1;
//        unsigned firstLoop  : 1;
    };
};

//--- G L O B A L  V A R I A B L E S -------------------------------------------
extern union DemoFlags flags;
extern unsigned short adc_value;

#endif	/* GLOBAL_DEF_H */
