//##############################################################################
//    filename:        uC_intrrupt.c
//##############################################################################
//    interrupt functions for uCQuick 2013 demo project
//##############################################################################
//
//      Author:            	V.SchK
//      Company:            THU-Ulm
//
//      Revision:           3.0 (XC8 C99 version)
//      Date:               June 2019
//      Assembled using     XC8 2.00+
//
//   	todo	- add comments ;-)
//             	-
//
//##############################################################################

/** I N C L U D E S ***********************************************************/
#include "global_def.h"


/** D E C L A R A T I O N S ***************************************************/
//##############################################################################
// Function:        void high_isr(void)
// PreCondition:    None
// Input:
// Output:
// Side Effects:
// Overview:
//##############################################################################
void __interrupt(high_priority) high_isr(void)
{
    if(ENC_IR){
        if(ENC_DIR == ENC_DIR_UP)  flags.encUp = 1;
          else flags.encDown = 1;

        mENC_IR_RST();          // clear flag and toggle edge if necessary
        return;
    }
//------------------------------------------------------------------------------
    if(ADC_IR){
//        static char tsec = 0;
        if (adc_value != ADRES){
            adc_value = ADRES;
            flags.newADC = 1;
        }
//        if(++tsec >= 10){       // adc sample rate is 10Hz
//            flags.newSec = 1;
//            tsec = 0;
//        }
        mADC_IR_CLR();
        return;
    }
//------------------------------------------------------------------------------
    while(1){;}     // (detect unexpected IR sources)
}

//##############################################################################
// Function:        void low_isr(void)
// PreCondition:    None
// Input:
// Output:
// Side Effects:
// Overview:
//##############################################################################
#ifdef USE_IR_PRIORITIES
void __interrupt(low_priority) low_isr(void)
{
    while(1){;}     // (detect unexpected IR sources)
}
#endif
