#include "configuration.h"

//#if LCD_SUPPORT == 1

    #include <p18cxxx.h>
    #include "delays.h" // fr die Warteschleife
    #include "lcd.h"
    #include "hardware.h"
    #include"hardware2.h"
    #include "inttypes.h"
    #include "main.h"
	//#include "string.h"

/*********************** LCD_ff ******************************************************************/

uint8_t		mr_busy_ausf =1;
uint8_t 	mr_letztes_zeichen;
uint8_t i;
uint8_t j;

LCDpos akt_pos;
LCDpos letzte_pos;

char	stringf[21]	="*Test*";
char *itoa(int value,char *string);
uint8_t lcd_neu=1;	//Auswahl LCD Anzeige
uint8_t lcd_alt=1;
LCD_t LCDx[2];
extern uint16_t td1s;   //fr LCD_bel
extern uint8_t d373_akt;
/*************************************************************************************************/

uint8_t isLCDBusy(void);
void writeLCDCmd(uint8_t zeichen);
void writeLCDInitCmd( uint8_t zeichen);

void LCD_ausw(void){
//	uint8_t lcd_alt=1;

	//zurck schreiben
	LCDx[lcd_alt].mr_letztes_zeichen = mr_letztes_zeichen;
	LCDx[lcd_alt].akt_pos = akt_pos;
	LCDx[lcd_alt].letzte_pos = letzte_pos;

	// neuen Wert schreiben
	mr_letztes_zeichen = LCDx[lcd_neu].mr_letztes_zeichen;
	akt_pos = LCDx[lcd_neu].akt_pos;
	letzte_pos= LCDx[lcd_neu].letzte_pos;
	lcd_alt = lcd_neu;
}
	


/**
 *	<LOKAL> Schreiben eines Steuerzeichens zu LCD OHNE BusyFlag-Abfrage
 */
void writeLCDInitCmd( uint8_t zeichen) {

//    LCD_RS_PIN = LCD_INSTRUCTION; //0
//    LCD_RW_PIN = LCD_WRITE; // 0 = Write to LCD module
    u373Bclr(sLCD_RS | sLCD_RW);
    
    dataPortWrite( ); // switch Port to Output
    LCD_DATA_LATCH = zeichen;
    wait_1us(1);    //eingefgt 23.12.22
#if defined (platine4028)
    u4028(lcd_neu); // Enable signal
//    wait_1us( 5 );
    u4028(rU4028);  //LCDE_0(lcd_neu); // Enable signal - LCD bernimmt bei fallender Flanke E
    //LCD_RS_PIN=1;   //auf Daten zurcksetzen (LCD_DATA) testweise
#endif
    
#if defined (platine_nur373)
    LCDE_1(lcd_neu); // Enable signal
//    wait_1us( 5 );
    LCDE_0(lcd_neu);  //LCDE_0(lcd_neu); // Enable signal - LCD bernimmt bei fallender Flanke E
    //LCD_RS_PIN=1;   //auf Daten zurcksetzen (LCD_DATA) testweise
#endif
    u373Bset(sLCD_RS);
    wait_1us(25);   //05.12.22 eingefgt wegen Fehler scr_up
}

/**
 *	Schreiben eines Steuerzeichens zu LCD MIT BusyFlag-Abfrage
 */
void writeLCDCmd( uint8_t zeichen) {
    while (isLCDBusy());
    wait_10us(1);
    writeLCDInitCmd( zeichen );
}

/*
 * <LOKAL> Warten auf LCD bereit
 */
uint8_t isLCDBusy(void) {
    uint8_t result;

    LCD_DATA_PORT = 0;
    //LCD_RS_PIN = LCD_INSTRUCTION; // 0 = Instruction mode
    //LCD_RW_PIN = LCD_READ; // 1 = Read LCD module
    u373Bclr(sLCD_RS);
    u373Bset(sLCD_RW);
    wait_1us(2);    //eingefgt wegen  u373
    dataPortRead( ); // switch Port to Input
    wait_1us(1);    //eingefgt 23.12.22
#if defined (platine4028) 
    u4028(lcd_neu); // Enable signal
#endif
    
#if defined(platine_nur373) 
    LCDE_1(lcd_neu); // Enable signal
#endif
//    wait_1us( 1 );	//original 5us
    result = LCD_DATA_PORT & LCD_BUSYFLAG;
#if defined (platine4028)
    u4028(rU4028);  //LCDE_0(lcd_neu); // Enable signal
#endif
    
#if defined(platine_nur373)
    LCDE_0(lcd_neu);
#endif            
	//LCD_RW_PIN =0;	//_ff wieder zurckgesetzt
    u373Bclr(sLCD_RW);
    wait_10us(1);	//falls Busy 10us zu frh gemeldet 9.7.22 ff
    return result;
}

/**********************************************/
#if defined(platine4028)
void initLCDPort(){
    init_hard2();   //RS R/W auf 1
    
}

#endif

void initLCD0(void){

//parameter initialisieren
	mr_letztes_zeichen = 0;
	akt_pos._lcdpos = 0;
	letzte_pos._lcdpos = 0;

//LCD-Anzeige initialisieren
    initLCDPort(); // Steuerleitungen auf inaktiv, Pins auf Output
	lcd_neu=0;	LCD_ausw();
    initLCD(); // LCD initialisieren
	wait_10ms(1);  //gendert original 10ms
	lcd_neu=1; LCD_ausw();
	initLCD();
	wait_10ms(5);  //gendert original 10ms
}	
/**********************************************/
/**
 *
 */
void initLCD(void) {
    //init LCDPort wird jetzt initLCD0 ausgef. gendert 13.12.23
    //initLCDPort(); // Steuerleitungen auf inaktiv, Pins auf Output

    // Initialisiere LCD-Display falls Power-On-Reset nicht richtig funktioniert
	wait_1ms(25);
    wait_1ms(25); // wait 15ms
    writeLCDInitCmd( LCD_FUNCTIONSET | LCD_8BITMODE );
    wait_1ms( 5 ); // wait 5ms
    writeLCDInitCmd( LCD_FUNCTIONSET | LCD_8BITMODE );
    wait_100us( 1 ); // wait 100ys
    writeLCDInitCmd( LCD_FUNCTIONSET | LCD_8BITMODE );

    // wartet, ob das LCD bereit ist
    wait_100us( 1 ); // wait 100ys
       //Abfrage weggelassen, testweise
//    if (isLCDBusy()) {
        // kein LCD
//        controlerconf.LCD = 0;
//    } else {
        controlerconf.LCD = 1;
        writeLCDCmd(0x3c);	//38
        writeLCDCmd(0x0c);	//08	
        writeLCDCmd(0x01);
        writeLCDCmd(0x06);

/*
        //initialisiere LCD Display
        writeLCDCmd( LCD_FUNCTIONSET | LCD_8BITMODE | LCD_2LINE | LCD_5x7DOTS |4| 2); //RE DH display shift
        writeLCDCmd( LCD_DISPLAYCONTROL | LCD_DISPLAYOFF | LCD_CURSOROFF | LCD_BLINKOFF );//_08
        writeLCDCmd( LCD_ENTRYMODESET | LCD_ENTRYLEFT | LCD_ENTRYSHIFTDECREMENT ); //_06
        //writeLCDCmd(LCD_RETURNHOME);

        writeLCDCmd( LCD_CLEARDISPLAY );
        writeLCDCmd( LCD_DISPLAYCONTROL | LCD_DISPLAYON | LCD_CURSOROFF | LCD_BLINKOFF );
*/
//    }
}

/**
 *	Schreiben eines Datenbytes zur LCD
 *	RC0 - RS
 *	RC1 - R /W
 *	RC2 - E
 *	RD - Daten
 */
void writeLCDRomData(const uint8_t const_c){  //fr printOut
    extern uint8_t last_c;
    uint8_t c;
    
    LCDpos l_pos;
    uint8_t zeile, spalte, tab;
    
    c= const_c;
    switch (last_c){
        case '\t':
            last_c =0;
            l_pos= LCD_wherexy();
            tab= c-0x30;    //0x30 mu voher addiert werden , ohne Prfung!!
            zeile = (l_pos.zeile);
            LCD_gotoxy(tab,zeile);
        break;
       // case'\v':   //
       //     last_c =0;
        //    zeile = c-0x30;
        //    LCD_gotoxy(0,zeile);
        //    break;
        default:
            switch (c){
               case '\n':   //setzt crsr auf letze Spalte (nur zhler)
                   akt_pos.nok=1;
                   letzte_pos.spalte_nok=19;
                   //        LCD_cr();  //hier wird sonst die letzte Zeile immer gescrollt, daher nicht genutzt
                   break;

               case '\r':
                   break; //tue nichts

               case '\t':  //tabulator aktuelle Zeile pos 10
                   last_c ='\t';
                   break;
                   
               //case '\v':
               //    last_c ='\v';
                //   break;
                   
               case '\f':
                   LCD_clrhome;
                   break;

               case '':
                   c = 0xdf;
                   break;

               case '':
               case '':   
                   c = 0xef;
                   break;

               case '':
               case '':   
                   c = 0xf5;
                   break;

               case'':
               case'':
                   c = 0xe1;
                   break;

               case '':
                   c = 0xe4;
                   break;

               case '':
                   c = 0xe2;  
                   break;
            }
            if ((c >31) && (last_c !='\t')){    //keine Steuerzeichen
    //_______________________________________
            //if (c !='\n')   //damit nicht zweimal ausgefhrt
            if (akt_pos.nok == 1)
                if (letzte_pos.spalte_nok == 19)	//spalte =19, mr=0 also nicht durch gotoxy usw gesetzt, heit letzte position gltig
                {
                    LCD_cr();
                }
    //_______________________________________
            writeLCDData(c);
            }
            //break;  //von default switch (last_c) nicht notwendig
     }
 }

void writeLCDData( uint8_t zeichen) {
    if (controlerconf.LCD) {
        while (isLCDBusy());
	
		if (akt_pos.nok== 0)
			letzte_pos = akt_pos;
		else letzte_pos = LCD_wherexy();

        //LCD_RS_PIN = LCD_DATA; // 1 = Data
        u373Bset(sLCD_RS);
        //LCD_RW_PIN = LCD_WRITE; // 0 = Write to LCD module
        u373Bclr(sLCD_RW);
        dataPortWrite( ); // switch Port to Output
        LCD_DATA_LATCH = zeichen;
        wait_1us(1);    //testweise 23.12.22
#if defined (platine4028)
        u4028(lcd_neu); // Enable signal 1

//        wait_1us( 1 );	//in LCDE_1
        u4028(rU4028);  //LCDE_0(lcd_neu); // Enable signal 0 - LCD bernimmt bei fallender Flanke von E
#endif
        
#if defined(platine_nur373)
        LCDE_1(lcd_neu);
        LCDE_0(lcd_neu);
#endif
		akt_pos.nok =1;
    }
}

/**
 *
 */
void writeLCDRomString(const rom char *data) {
    if (controlerconf.LCD) {
        while (*data) {
            LCD_Out( *data++ );		//writeLCDData
        }
    }
}

/**
 * Sendet ein Digit (0..F) ber USB als ASCII
 */
void writeLCDDigit(uint8_t byte) {
    byte = (byte & 0x0F) + '0';
    if (byte > '9') {
        byte += 7;
    }
    writeLCDData( byte );
}

void writeLCDHex(uint8_t byte) {
    writeLCDDigit( (byte & 0xF0) >> 4 );
    writeLCDDigit( byte & 0x0F );
//    writeLCDData( ' ' );
}

void writeLCDBin(uint8_t value){
    
    uint8_t zeichen, i;
    
    for  (i=0;i<8;++i) {
      zeichen = (value & 0x80)?'1':'0';
      value << 1;
      writeLCDData( zeichen );
    }
 }

/*********************** LCD_ff ******************************************************************/
// Enable=1
/*************************************************************************************************/
#if defined (platine_nur373) | defined (platine_keine)
void LCDE_1(uint8_t LCDx)
{
    LATEbits.LATE0 = 1; //USB auf !RD
    TRISEbits.RE0 =0;
	switch(LCDx)
	{
		case 0: 
			LCD0_E =1;
		break;
		
		case 1:
			LCD1_E =1;	
		break;
	}	
	wait_1us( 5 );
}

// Enable=0

void LCDE_0(uint8_t LCDx)
{
    //vorsichtshalber nochmal USB auf !RD schalten
    LATEbits.LATE0 = 1; //USB auf !RD
    TRISEbits.RE0 =0;
    
	switch(LCDx)
	{
		case 0: 
			LCD0_E =0;
		break;
		
		case 1:
			LCD1_E =0;	
		break;
	}	
	wait_1us( 25 );
}
#endif
/************************************************************************************************/

// warten bis das display bereit ist
char LCD_BUSY(char *ad)
{
	unsigned int z;
	char mr;
	//RB4..7 auf input
	z=0;
	mr=0;

	if (mr_busy_ausf ==1)	//fr Testzwecke
	{
		//LCD_RW = 1;
		//LCD_RS = 0;
        u373Bset(sLCD_RW);
        u373Bclr(sLCD_RS);  
		//tris_LCD_DATA |= LCD_DATAbits;
        tris_LCD_DATA = 0xff;
		do
		{
#if defined (platine4028)
			u4028(lcd_neu);
#endif
#if defined(platine_nur373)
            LCDE_1(lcd_neu);
#endif
                    
                    
			*ad = PORTD;//					puffer._byte = PORTD;
#if defined (platine4028)
			u4028(rU4028);  //LCDE_0(lcd_neu);
#endif
#if defined(platine_nur373)
            LCDE_0(lcd_neu);
#endif
			z++;

/*
			LCDE_1();
			*ad = PORTB&0xf0;//hi					puffer._byte = PORTB;
			LCDE_0();
			LCDE_1();
			*ad|= ((PORTB&0xf0)>>4);//PORTB
			LCDE_0();
			z++;
*/
			if (z>=1000) {
               mr=-1; 
               break;
               }//return(-1);	//Zeitberschreitung
        } while (*ad&0x80); //gendert weil es !=mr heit
//		} while ((*ad&0x80)& !mr);  
		*ad &= 0x7f; // busy bit lschen fr Rckgabe	

	wait_10us(1);	//falls Busy 10us zu frh gemeldet
	//RB4..7 auf output
	//tris_LCD_DATA &= ~LCD_DATAbits;
    tris_LCD_DATA =0x00;
	//LCD_RW = 0;
    u373Bclr(sLCD_RW);
	}
	return(mr);
}

/*
//8 Bit als 2x4 Bit zum LCD schreiben
void LCD_Data(byte daten)
// RW = 0;

{
	byte daten1;
	daten1 = daten;
	//high
	LATB = (LATB & 0x0F) | (daten1 & 0xF0);
	LCDE_1();
	LCDE_0();
	//low
	LATB = (LATB & 0x0F) | ((daten1 & 0x0F) << 4);
	LCDE_1();
	LCDE_0();
}
*/

LCDpos LCD_wherexy(void)
{
	LCDpos crsr;
	char spalte; //nochmal definiert, da bei .spalte >1f 1bit fehlt
	char adresse;
	LCD_BUSY(&adresse);
	crsr.zeile0 =  adresse/0x40; 
	spalte = adresse%0x40;
	if (spalte>0x13) 
	{
		crsr.zeile1=1;
		spalte-=0x14;
	}
	else crsr.zeile1=0;

//	crsr.mr =0;
	crsr.spalte = spalte;
	return crsr;
}


void LCD_Out( uint8_t daten)
{
	char adresse;

	LCD_BUSY(&adresse);

//	akt_pos = LCD_wherexy();
/*
	//0x00 - 0x13	/0x40 =0	rest <0x14	0
	//0x40 - 0x53	/0x40 =1	rest <0x14	0
	//0x14 - 0x27	/0x40 =0	rest >=0x14	1
	//0x54 - 0x67	/0x40 =1	rest >=0x14	1
*/	
/*
	if (daten !='\n')   //damit nicht zweimal ausgefhrt
        if (akt_pos.nok == 1)
            if (letzte_pos.spalte_nok == 19)	//spalte =19, mr=0 also nicht durch gotoxy usw gesetzt, heit letzte position gltig
            {
                LCD_cr();
            }
	//writeLCDData(daten);
*/
    writeLCDRomData(daten); //auch Umlaute
}
	

void LCD_Out_test(uint8_t daten)
{
	char adresse;

	LCD_BUSY(&adresse);
	//0x00 - 0x13	/0x40 =0	rest <14	0
	//0x40 - 0x53	/0x40 =1	rest <14	0
	//0x14 - 0x27	/0x40 =0	rest >=14	1
	//0x54 - 0x67	/0x40 =1	rest >=14	1

	if ((adresse > 0x13) && (adresse < 0x28))
	{
		LCD_gotoxy(adresse-0x14,1);
		writeLCDData(daten);
		LCD_gotoxy(adresse-0x13,2);	//x+1

	}

	if ((adresse > 0x3f) && (adresse < 0x54))
	{
		LCD_gotoxy(adresse-0x40,2);
		writeLCDData( daten);
		LCD_gotoxy(adresse-0x3f,1);// x+1
	}
	if (adresse==0x67) mr_letztes_zeichen=1;	//setzen und lschen in LCD_Out0 busy????
	if ((adresse==0x00) & mr_letztes_zeichen) 
	{
		LCD_scr_up ();
		writeLCDData( daten);	//3.Zeile 1.Zeichen wird sonst unterschlagen
	}

	else
	{
		if ((adresse<0x14) || ((adresse>0x53)&&(adresse<0x68)))
		writeLCDData( daten);
	}
	if (adresse !=0x67) mr_letztes_zeichen=0;
}	

/*
// zeichen schreiben
void LCD_Out0(byte daten)
{
	{
	
	//	LCD_BUSY();
		LCD_RS = 1;
		LCD_Data(daten);
	
//		xy++;
//		lcd_merker.b3 = 1; // spalte ist grer 0 da crsr automatisch 1 weiter fhrt
	}
}
*/
/* steuerung: 
	RS= 0
	RW	7	6	5	4	3	2	1	0		$
---------------------------------------------------------------------------------------------------
	0	0	0	0	0	0	0	0	1		01	clr_home	lscht Anzeige und setzt CRSR auf pos. 0,0
	0	0	0	0	0	0	0	1	x		02	crsr_home	Anzeige wird nicht gelscht, CRSR auf pos. 0,0
	0	0	0	0	0	0	1	ID	S			Modus set.	ID Bewegungsrichtung des CRSR (li,re), S zeile verschieben (ein,aus) - wird ausgef. beim zugriff auf Daten
	0	0	0	0	0	1	D	C	B			Displ-a/e	D Anzeige aus/ein,	C CRSR aus/ein, B CRSR bli aus/ein
	0	0	0	0	1	SC	RL	x	x						SC CRSR verschieben/Zeile verschieben	RL links/rechts
	0	0	0	1	DL	N	F	x	x			Anz_init	--nur nach einschalten--
	0	0	1	ADRESS CG RAM 40-7F--						setzt das Adressregister um Zeichensatz zu definieren
	0	1	---ADRESS DD RAM 80-FF--- 			LCD_gotoxy	setzt das Adressregister um CRSR zu setzen
	1	BF	ADRESS CG oder DD RAM----			BUSY		BF bereit/beschftigt	

(bei LCD_Out >> RS=1 8bit Daten schreiben oder lesen auf CG oder DD RAM vorher Adressregister setzen)
*/ 

void LCD_Control(uint8_t daten)
{
//	LCD_BUSY();//??
//	LCD_RS = 0;	//wird in write LCDInitCmd ausgefhrt
	writeLCDInitCmd(daten);

	if (daten <4){ 	// clr_home, home
        akt_pos._lcdpos = 0;
        wait_1ms(5);
	}
	wait_10us(13);
}

//steuerung
void LCD_Control_noBF(uint8_t daten)
{
//	LCD_BUSY();//??

	//LCD_RS = 0;
    u373Bclr(sLCD_RS);
	writeLCDCmd(daten);
}

/*
void LCD1_init(void)
{
	LCD_spalten = 20;
	SleepMs(20);
*/

/*
	LCD_D4 = 0;
	LCD_D5 = 0;
	LCD_D6 = 0;
	LCD_D7 = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E1 = 0;
*/

/*
	
	LCD_CONTR &= ~LCD_CONTRbits;	//controllbits lschen
	LCD_DATA &= ~LCD_DATAbits;		//datenbits lschen
	
	tris_LCD_CONTR &= ~LCD_CONTRbits;	//ausgang
	tris_LCD_DATA &= ~LCD_DATAbits;		//ausgang

	LCD_D4 = 1;		// 8 bit
	LCD_D5 = 1;
	SleepUs(100);
	LCD_E1 =1;
	SleepUs(100);
	LCD_E1 =0;
	SleepUs(100);
	SleepMs(20);

	LCD_E1 =1;
	SleepUs(100);
	LCD_E1 =0;
	SleepUs(100);
	SleepUs(100);	// 0011**** //  100+100us

	LCD_E1 =1;
	SleepUs(100);
	LCD_E1 =0;
	SleepUs(100);
	SleepUs(100);	// 0011**** // 100+100us

	LCD_D4 = 0;		// 4 bit
	LCD_D5 = 1;
	SleepUs(100);
	LCD_E1 =1;
	SleepUs(100);
	LCD_E1 =0;
	SleepUs(100);
			
	LCD_Control_noBF(0x0e);	//function set, 4-bit  2-zeilig,  5x7  ***0x28
	SleepUs(100);
	LCD_Control_noBF(0x08);		SleepUs(100);	//display off
	LCD_Control_noBF(0x01);	//	tmr3Ms(2);	//lschen
	SleepMs(3);
	LCD_Control_noBF(0x06);		SleepUs(100);	//entry mode, increment, disable display-shift 0x06
	//LCD_Control_noBF(0x0F);	SleepUs(100);	//on, kursor on, blink	//display on
	LCD_Control_noBF(0x0c);		SleepUs(100);	//on, kursor off, no-blink	//display on

	letzte_pos._lcdpos =0;
}

*/

/*
void LCD_gotoxy_test(byte spalte, byte zeile)
{
	if (zeile == 2) zeile =1;
	else if (zeile ==1) zeile =2;
	LCD_gotoxy(spalte, zeile);
	
}
*/

void LCD_gotoxy(uint8_t spalte, uint8_t zeile)
{
	uint8_t Adresse;

	akt_pos.spalte_nok = spalte;	//hier Spalte gleich merken, wird verndert
	akt_pos.zeile = zeile;
	letzte_pos.nok =1;	//letzte position nicht mehr gltig


	// 2: Zeile 0..3
	// 3: Spalte 0..39
	// Zeile 0: 0x00
	// Zeile 1: 0x40
	// Zeile 2: 0x00+Zeilenlnge
	// Zeile 3: 0x40+Zeilenlnge

	if (zeile>1) //Zeile2, 3
	{
		spalte += 20; //LCD_spalten;
	}
	Adresse = ((zeile & 0x01) * 0x40) + spalte;
	writeLCDCmd(Adresse | 0x80);

	wait_1us (25);//_ff testweise org. 25us

}


void LCD_cr(void)
{
	LCDpos crsr;
	if (akt_pos.nok == 0) crsr = akt_pos;
	else
		if (letzte_pos.nok == 0) crsr = letzte_pos;

	if (crsr.zeile < 3)
		LCD_gotoxy(0,crsr.zeile+1); //setzt nur crsr, lscht aber nicht zeile
//		LCD_delline(letzte_pos.zeile+1);// lscht folgende Zeile und setzt crsr
	
	else 									//(lezte_pos == 0b01001111)	// mr0 gltig,spalte=19,zeile=3
	{
 		LCD_scr_up ();	//evtl bild_up
//		LCD_delline(3); wird in scr_up ausgefhrt
//		LCD_gotoxy(0,3);wird in scr_up ausgefhrt
	}
	
}

void LCD_scr_up (void){
	uint8_t erg1;
    char speicher[20];
    uint8_t ze, i;
    
    for(ze=0; ze<3; ze++){
        //LCD_gotoxy(0,ze+1);
        for(i=0;i<20;i++){
            LCD_gotoxy(i,ze+1);   //Anzeige rckt automatisch eine Spalte weiter?
            LCD_read_data(&erg1);
            speicher[i] = erg1;
        }
        LCD_gotoxy(0,ze);
        for(i=0;i<20;i++){
            writeLCDData(speicher[i]);
        }
    }
    LCD_delline(3);
}

/*
void LCD_scr_up (void)
{
	uint8_t erg1;
	uint8_t sp,ze;

	for (ze=0; ze<3;ze++)	//ze=0; ze<3;ze++
		for (sp=0; sp<20;sp++) //sp=0; sp<20;sp++
		{	
			LCD_gotoxy(sp,ze+1);
			LCD_read_data(&erg1);
 			LCD_gotoxy(sp,ze);
			writeLCDData(erg1);
		}
	LCD_delline(3);
//	letzte_pos.mr = 1;// letzte position nicht mehr gltig -- wird in delline-gotoxy ausgefhrt
}
*/

void LCD_delline(uint8_t zeile)
{
	uint8_t spalte;
	LCD_gotoxy(0,zeile);
	for (spalte=0;spalte<20;spalte++)	//<19
        writeLCDData(' ');
	LCD_gotoxy(0,zeile);	//hier wird auch letzt_pos.mr gesetzt (nicht mehr gltig)
}		

void LCD_read_data(uint8_t *erg)
{
	//LCD_BUSY();
    tris_LCD_DATA = 0xff;
	//LCD_RW = 1; //1-lesen
  	//LCD_RS = 1; //1-Daten
    u373Bset(sLCD_RW | sLCD_RS);
    wait_1us (20); //eingefgt wegen Fehler LCD_scr_up 28.12.22
#if defined (platine4028)
	u4028(lcd_neu);
#endif
#if defined(platine_nur373)
    LCDE_1(lcd_neu);
#endif           
	*erg = LCD_DATAin;	//PORTB&0xf0;//hi
#if defined (platine4028)
	u4028(rU4028);  //LCDE_0(lcd_neu);
#endif
#if defined(platine_nur373)
    LCDE_0(lcd_neu);
#endif
    
    //wait_1us (10); //eingefgt wegen Fehler LCD_scr_up 28.12.22
 /*	LCDE_1();
	*erg |= ((PORTB&0xf0)>>4);//PORTB
	LCDE_0();
*/
    //tris_LCD_DATA =0x00; //testweise weg
	//LCD_RW = 0; //0-schreiben soll in LCDOut gesetzt werden 9.7.22
}

void LCD_string(char* pstring)
{
//	char zeichen;
//	zeichen =*pstring;
	while(*pstring >0)//	while(zeichen >0)	
	{	
		//writeLCDData(*pstring);	//	LCD_Out(zeichen);
        writeLCDRomData(*pstring);  //gendert 5.1.23 FF
		pstring++;
//	zeichen = *pstring;
	}
}

/*
void LCD_mem_string(unsigned short long *pstring)
{
	char s10[81];
	copy_block((unsigned short long) *pstring,(word) s10,20);
	LCD_string(s10);
}
*/

/*
void hex_n_ausg(unsigned char *s,byte len)
{
	while (len--)
	{
		ausg8b(*s);
		s++;
	}
}
*/
/*
void LCD_char_const(char *pstring,byte konst) //mit blank fllen
//memmove(s1,stringf,strlen(stringf)+1);
	{
	if (strlen(pstring) < konst)
*/		

/*
void copy_test(void)
{
	for (i=0; i<3;i++)
		for (j=0; j<2;j++)
		{
			
			LCD_gotoxy(i,j);
			LCD_read_data(&erg);
			LCD_gotoxy(10+i,j);
			LCD_Out(erg);
		}
	
			LCD_gotoxy(0,2);
//			LCD_string(stringf);
			LCD_gotoxy(0,2);
//			LCD_string("test1234");
			LCD_gotoxy(0,3);
			LCD_string(stringf);

}
*/

void hex_dec_ausg (int hex)
{
	char string[7]; // gendert 7 Byte reichen -32768 bis 32767 +/0 05.05.22 FF (orig 20)
	itoa(hex,string);
	LCD_string(string);
}

/*
void long_dec_ausg(word hex)
{
char string[20];
ltoa(hex,string);
LCD_string(string);
}
*/

void strset(char *pstring,char ch)
{
	while(*pstring !=0) 
//?	while(*pstring)
	{	
		*pstring = ch;	
		pstring++;
	}
}



//fllt mit ch vor s2 auf und gibt s1 zurck, zeichenanzahl von s2 ist n-Zeichen
//s1 Rckgabestring, s2 Vorgabe, ch zu fllende Zeichen, n anzahl der Zeichen
/*void strncpylen(char *s1,char *s2,char ch,size_t n) 
{
	if (n >= strlen(s2))
	{	
		strset(s1,ch);
		strcpy(s1+n-strlen(s2),s2);
	}
		else
		strcpy(s1,s2);
	s1[n]=0;
}	
*/
void ascii_code(void)
{
	uint8_t i,i0,i1;
	i1=0;
	writeLCDCmd(1); //CLRHOME
	for (i0=0x1f; i0<0xff;) //255
	{
		i0++;
		if (i0==128) i0+=32;  //bei =+ folgt statt 160 32
		writeLCDHex(i0);
		i1=i1+2;
        LCD_Out(i0);
		//writeLCDData(i0);
		i1++;
        LCD_Out(' ');
 		//writeLCDData(' ');
		i1++;
		if (i1==20) 
		{
			for (i=0; i<5; i++)
			{
				wait_10ms(20);
			}
			LCD_cr();  //sollte am Zeilenende automatisch gehen
			i1=0;
		}
		wait_10ms(25);
	}
	LCD_cr();
	LCD_cr();
//	writeLCDData(0x30|lcd_merker.b5);
}

void LCD_Bel(uint16_t bel_sec ){

    if (bel_sec >0){
        td1s= bel_sec;  // timer stellen
        if (!(sLCD_BL & d373_akt)) u373Bset(sLCD_BL); //wenn aus dann einschalten
    }
    else {  //keine Zeitangabe heit nach Zeit abschalten
    if (sLCD_BL & d373_akt) // LCD_Bel eingeschaltet?
        if (td1s==0) {
            u373Bclr(sLCD_BL); // LCD_Bel. abschalten
            LED_bl = LED_OFF;  // blaue LED aus wurde bei Zeit >60 sec (menu) eingeschaltet
        }       
    }
 }
	

/**************************************************************************************************/
// (#if LCD_SUPPORT)
/*
#else
typedef int dummy;
#endif
*/
