#ifndef lcd_h
#define lcd_h

/*
 Timing:
        Enable: > 450 ns HIGH
        Enable-Cycle: > 1000 ns
        gltige Daten von fallender Flanke Enable: >195 ns

        Lesen:
        - Daten gltig 320 ns nach Enable = HIGH

        Bei 4 MHz -> NOP = 1ys

 */
#include "inttypes.h"

// Clear display
#define LCD_CLEARDISPLAY 0x01

// Cursor home
#define LCD_RETURNHOME 0x02

// Entry mode set
#define LCD_ENTRYMODESET 0x04

#define LCD_ENTRYRIGHT 0x00
#define LCD_ENTRYLEFT 0x02
#define LCD_ENTRYSHIFTINCREMENT 0x01
#define LCD_ENTRYSHIFTDECREMENT 0x00

// Display On/Off control
#define LCD_DISPLAYCONTROL 0x08
#define LCD_DISPLAYON 0x04
#define LCD_DISPLAYOFF 0x00
#define LCD_CURSORON 0x02
#define LCD_CURSOROFF 0x00
#define LCD_BLINKON 0x01
#define LCD_BLINKOFF 0x00

// Cursor/display shift
#define LCD_CURSORSHIFT 0x10
#define LCD_DISPLAYMOVE 0x08
#define LCD_CURSORMOVE 0x00
#define LCD_MOVERIGHT 0x04
#define LCD_MOVELEFT 0x00

// Function set
#define LCD_FUNCTIONSET 0x20
#define LCD_8BITMODE 0x10
#define LCD_4BITMODE 0x00
#define LCD_2LINE 0x08
#define LCD_1LINE 0x00
#define LCD_5x10DOTS 0x04
#define LCD_5x7DOTS 0x00

// Set CGRAM address
#define LCD_SETCGRAMADDR 0x40
#define LCD_CGRAMADDRMASK 0x3F

// Set DDRAM address
#define LCD_SETDDRAMADDR 0x80
#define LCD_DDRAMADDRMASK 0x7F

// Busy-Flag
#define LCD_BUSYFLAG 0x80
#define LCD_BUSYFLAGMASK 0x7F

// RS-Line
#define LCD_INSTRUCTION 0
#define LCD_DATA 1

// R/W-Line
#define LCD_WRITE 0
#define LCD_READ 1

// Enable-Line (nutzt fallende Flanke)
#define LCD_DISABLE 0
#define LCD_ENABLE 1

// 4x20 Display
#define LCD_POSITION_1 0x00	// Zeile 1, Pos 0
#define LCD_POSITION_2 0x40	// Zeile 2, Pos 0
#define LCD_POSITION_3 0x14	// Zeile 3, Pos 0
#define LCD_POSITION_4 0x54	// Zeile 4, Pos 0


/**************** LCD_ff.h *********************************************************/
/** D E F I N I T I O N S ****************************************************/
//#define	LCD_E1			LCD_E_PIN //LATCbits.LATC2  //enable display 1

#define	LCD_RS	LCD_RS_PIN		//LATCbits.LATC0
#define	LCD_RW	LCD_RW_PIN		//LATCbits.LATC1

//#define LCD_RS_PIN	LATCbits.LATC0  // 0-Instruction, 1- Data
//#define LCD_RW_PIN	LATCbits.LATC1  // 0-Write, 1-READ
/*
#define	LCD_D4			LATDbits.LATD4
#define	LCD_D5			LATDbits.LATD5
#define	LCD_D6			LATDbits.LATD6
#define	LCD_D7			LATDbits.LATD7
*/

//#define tris_LCD_CONTR		TRISC // TRISC &=0x8f Controlbits auf Ausg.
//#define LCD_CONTR		LATC

//#define	LCD_CONTRbits		0x07

#define tris_LCD_DATA		TRISD // TRISB &=0x0f DATAbits auf Ausg.
//#define LCD_DATAout			LATD
#define LCD_DATAin			PORTD
#define LCD_DATAbits		0xff // bei 8 Bit

#define _CR				0x0d				//neue Zeile
#define LCD_clrhome		LCD_Control(1)

#define LCD_spalten	20

typedef union _LCDpos
{
	unsigned char	_lcdpos;
	struct
	{
		unsigned zeile:2;
		unsigned spalte:5;
		unsigned nok:1;	//0=position ok
	};
	struct
	{
		unsigned zeile0:1;
		unsigned zeile1:1;
		unsigned spalte_nok:6;	//543210  32..1
	};
}LCDpos;

/****** ende LCD_ff.h **********************************************************************/
/*******typedef variablen  25.12.18  ***********/

typedef struct {
	uint8_t mr_letztes_zeichen;
	LCDpos akt_pos;
	LCDpos letzte_pos;
}LCD_t;
//
//in Hardware (LCD0) LATCbits.LATC2
//#define	LCD_E1			LCD_E_PIN
//#define initLCDPort() in hardware

/*********************************************/
//#if LCD_SUPPORT == 1

extern uint8_t lcd_neu;	//Auswahl LCD
extern void ausg8b(uint8_t byte);

void initLCDPort(void); //_ff eingefgt wegen 4028 / 74373
void LCD_ausw(void);
void initLCD0(void);
void initLCD(void);
void writeLCDCmd(uint8_t zeichen);
void writeLCDRomData(const uint8_t const_zeichen);
void writeLCDData(uint8_t zeichen);
void writeLCDRomString(const rom char *data);
void writeLCDDigit(uint8_t byte);
void writeLCDHex(uint8_t byte);
void writeLCDBin(uint8_t value);

/**************** LCD_ff.h *********************************************************/
/** P R I V A T E  P R O T O T Y P E S ***************************************/
void hex_dec_ausg(int hex);
//void long_dec_ausg(word hex);
//void LCD1_init(void);
void LCD_cr (void);
void LCD_gotoxy(uint8_t spalte, uint8_t zeile);
void LCD_scr_up (void);
void LCD_delline(uint8_t zeile);
void LCD_read_data(uint8_t *erg);
void copy_test(void);
void LCD_string(char *pstring);
//void LCD_mem_string(unsigned short long *pstring);
void LCD_Control(uint8_t daten);
void LCD_Control_noBF(uint8_t daten);
LCDpos LCD_wherexy(void);
void LCD_Out(uint8_t daten);
//void LCD_Out0(byte);
// #if defined (platine_nur373) | defined (platine_keine)
void LCDE_1(uint8_t LCDx);
void LCDE_0(uint8_t LCDx);
// #endif
char LCD_BUSY(char *ad);
//void LCD_Data(byte daten);
void strset(char *pstring,char ch);
//void strncpylen(char *s1,char *s2,char ch,size_t n);
void ascii_code(void);
void LCD_Bel(uint16_t bel_sec );

/***** ende LCD_ff.h***********************************************************************/
/*
#else
#define initLCD()
#define writeLCDCmd(...)
#define writeLCDData(...)
#define writeLCDRomString(...)
#define writeLCDDigit(...)
#define writeLCDHex(...)
#endif
*/


#endif lcd_h
