 ;** I N C L U D E S **********************************************************/
;	list p=18f4550
#include <p18cxxx.inc>
;#include "p18f4550.inc"
	global ausg16b,ausg12b, ausg8b, READ_BYTE, flash_read, config_write, copy_block	; ausg4bit, testasm, merker
	global eeprom_read, eeprom_write, eeprom_refesh, DATA_EE_ADDR, DATA_EE_DATA, abs, float4li
	extern LCD_Out, btoa, btoBCD	; testc
;	extern hexa
	
	
;unbanked	udata_shr

;W_save		    res	    1

;bank0	
	udata;	_acs

hexa	res	1
outp res 1
testvara res 1 
merker	res 1

DATA_EE_ADDR RES 1
DATA_EE_DATA RES 1

COUNTER RES 1
COUNTER1 RES 1
BUFFER_ADDR_HIGH RES 1
BUFFER_ADDR_LOW RES 1
CODE_ADDR_UPPER RES 1
CODE_ADDR_HIGH RES 1
CODE_ADDR_LOW RES 1
DATA_ADDR_HIGH RES 1
DATA_ADDR_LOW RES 1
NEW_DATA_HIGH RES 1
NEW_DATA_LOW RES 1
abs_lo		RES 1
abs_hi		RES 2

;Eingang nur 4 Bit erlaubt
get_lo	res 1	
get_lo1 res 1

;variablen fr test4li
;Ausgang als BCD bcd1 7:4,3:0 bcd0 7:4,3:0
zaehler	res 1
bcd0	res 1
bcd1	res 1
zsp		res 1

;** D E C L A R A T I O N S **************************************************

lcdtest	code

lesen:
	movlb merker;	beginnt mit 0
	DECF merker,F,BANKED	;	movlb merker
	movf merker,W,BANKED
	MOVF PLUSW1, W, ACCESS


;	movff FSR1L,FSR2L
;	movff FSR1H,FSR2H
;	movwf POSTINC1,0
	MOVLB hexa
	MOVWF hexa,BANKED	
	RETURN 0

p_to_fsr0:
; merker mit 0xff starten
	MOVLB merker
	MOVF merker,W,BANKED
	MOVFF PLUSW1, FSR0H

	DECF merker,F,BANKED
	MOVF merker,W,BANKED

	MOVFF PLUSW1, FSR0L

	DECF merker,F,BANKED

	RETURN 0

ausg12b:
	movlb merker
 	CLRF merker,BANKED	;movlw 0xff
	RCALL lesen
	rcall ausg4bit	
	bra ausg8b1	;bra ausg8b2

ausg16b:
	rcall ausg8b ;rcall ausg4bit
;	movff ADRESL,hexa

;ausg8b2:
	;movlw 0xfe
	bra ausg8b1
ausg8b:
	movlb merker
	CLRF merker,BANKED	;movlw 0xff
ausg8b1:
	RCALL lesen
ausg8b0:
	movff hexa,outp
	BANKSEL outp
	swapf outp,F,BANKED
	rcall out_bcd
ausg4bit:
	movff hexa,outp
;	movlb merker
;	DECF merker,F,BANKED

out_bcd:
	BANKSEL outp
	movlw 0x0f	;movf 0x0f,0,1	;MOVF f,d,a Move f
	andwf outp,1,1	;ANDWF f,d,a AND WREG with f
	movlw 0x9
	CPFSGT outp,1	;CPFSGT f,a Compare f with WREG, skip if f > wreg     if f > WREG, PC+4 ? PC
	goto verz2
	movlw 0x07
	ADDWF outp,1,1	;ADDWF f,d,a ADD WREG to f
verz2:	movlw 0x30
	ADDWF outp,1,1 ;ADD WREG to f
	movff outp,POSTINC1
	call	LCD_Out
	MOVF POSTDEC1, F, ACCESS
	RETURN 0

eeprom_read:
	MOVF DATA_EE_ADDR,0,0 ;(movlw)
	MOVWF EEADR,0 ; Lower bits of Data Memory Address to read
	BCF EECON1, EEPGD ; Point to DATA memory
	BCF EECON1, CFGS ; Access EEPROM
	BSF EECON1, RD ; EEPROM Read
	MOVF EEDATA, W,0 ; W = EEDATA
	return 0

eeprom_write:
	MOVF DATA_EE_ADDR,0,0 ; (movlw)
	MOVWF EEADR,0 ; Lower bits of Data Memory Address to write
	MOVF DATA_EE_DATA,0,0 ; (movlw)
	MOVWF EEDATA,0 ; Data Memory Value to write
	BCF EECON1, EEPGD ; Point to DATA memory
	BCF EECON1, CFGS ; Access EEPROM
	BSF EECON1, WREN ; Enable writes
	BCF INTCON, GIE ; Disable Interrupts
	MOVLW 55h ;
	MOVWF EECON2 ; Write 55h
	MOVLW 0AAh ;
	MOVWF EECON2 ; Write 0AAh
	BSF EECON1, WR ; Set WR bit to begin write
	BSF INTCON, GIE ; Enable Interrupts
; User code execution
	BCF EECON1, WREN ; Disable writes on write complete (EEIF set)
	return 0


eeprom_refesh:
	CLRF EEADR ; Start at address 0
	BCF EECON1, CFGS ; Set for memory
	BCF EECON1, EEPGD ; Set for Data EEPROM
	BCF INTCON, GIE ; Disable interrupts
	BSF EECON1, WREN ; Enable writes
Loop: ; Loop to refresh array
	BSF EECON1, RD ; Read current address
	MOVLW 55h ;
	MOVWF EECON2 ; Write 55h
	MOVLW 0AAh ;
	MOVWF EECON2 ; Write 0AAh
	BSF EECON1, WR ; Set WR bit to begin write
	BTFSC EECON1, WR ; Wait for write to complete
	BRA $-2
	INCFSZ EEADR, F ; Increment address
	BRA Loop ; Not zero, do it again
	BCF EECON1, WREN ; Disable writes
	BSF INTCON, GIE ; Enable interrupts

	return 0

flash_read:
	movlb merker
 	CLRF merker,BANKED
	RCALL lesen

;	MOVWF CODE_ADDR_UPPER ; Load TBLPTR with the base
	MOVWF TBLPTRU,0 ; address of the word

 ;	movlw 0xfe
	RCALL lesen

;	MOVLW CODE_ADDR_HIGH
	MOVWF TBLPTRH,ACCESS

; 	movlw 0xfd
	RCALL lesen

;	MOVLW CODE_ADDR_LOW
	MOVWF TBLPTRL,ACCESS

READ_BYTE:
	TBLRD*+ ; read into TABLAT and increment
	MOVF TABLAT, W,ACCESS ; get data


;	MOVWF WORD_EVEN
;	movlb hexa
;	movwf hexa,1
;	movwf POSTINC1,0
;	call	ausg8b
;	MOVF POSTDEC1, F, ACCESS

;	TBLRD*+ ; read into TABLAT and increment
;	MOVF TABLAT, W,0 ; get data
;	MOVF WORD_ODD

;	movwf POSTINC1,0
;	movwf hexa,1
;	call	ausg8b
;	MOVF POSTDEC1, F, ACCESS

	return 0

copy_block:
	call config_write
	goto READ_BLOCK
	


;EXAMPLE 6-3: WRITING TO FLASH PROGRAM MEMORY S86
config_write:
		movlb merker
		CLRF merker,BANKED

		RCALL lesen
	;MOVLW CODE_ADDR_UPPER ; Load TBLPTR with the base
	MOVWF TBLPTRU,ACCESS ; address of the memory block
		RCALL lesen
	;MOVLW CODE_ADDR_HIGH
	MOVWF TBLPTRH,ACCESS
		RCALL lesen
	;MOVLW CODE_ADDR_LOW
	MOVWF TBLPTRL,ACCESS

		RCALL lesen
	;MOVLW BUFFER_ADDR_HIGH ; point to buffer
	MOVWF FSR0H,ACCESS
		RCALL lesen
	;MOVLW BUFFER_ADDR_LOW
	MOVWF FSR0L,ACCESS


		RCALL lesen
	;MOVLW .64 ; number of bytes in erase block
		MOVLB COUNTER
	MOVWF COUNTER,BANKED
	nop
	RETURN 0

READ_BLOCK:
	TBLRD*+ ; read into TABLAT, and inc
	MOVF TABLAT, W,0 ; get data
	MOVWF POSTINC0,0 ; store data
	DECFSZ COUNTER,1 ; done?
	BRA READ_BLOCK ; repeat

	RETURN 0

MODIFY_WORD:
	MOVLW DATA_ADDR_HIGH ; point to buffer
	MOVWF FSR0H
	MOVLW DATA_ADDR_LOW
	MOVWF FSR0L
	MOVLW NEW_DATA_LOW ; update buffer word
	MOVWF POSTINC0
	MOVLW NEW_DATA_HIGH
	MOVWF INDF0
ERASE_BLOCK:
	MOVLW CODE_ADDR_UPPER ; load TBLPTR with the base
	MOVWF TBLPTRU ; address of the memory block
	MOVLW CODE_ADDR_HIGH
	MOVWF TBLPTRH
	MOVLW CODE_ADDR_LOW
	MOVWF TBLPTRL
	BSF EECON1, EEPGD ; point to Flash program memory
	BCF EECON1, CFGS ; access Flash program memory
	BSF EECON1, WREN ; enable write to memory
	BSF EECON1, FREE ; enable Row Erase operation
	BCF INTCON, GIE ; disable interrupts
	MOVLW 55h
	MOVWF EECON2 ; write 55h
	MOVLW 0AAh
	MOVWF EECON2 ; write 0AAh
	BSF EECON1, WR ; start erase (CPU stall)
	BSF INTCON, GIE ; re-enable interrupts
	TBLRD*- ; dummy read decrement
	MOVLW BUFFER_ADDR_HIGH ; point to buffer
	MOVWF FSR0H
	MOVLW BUFFER_ADDR_LOW
	MOVWF FSR0L
	MOVLW .2
	MOVWF COUNTER1
WRITE_BUFFER_BACK:
	MOVLW .64	;.32 _FF ; number of bytes in holding register 
	MOVWF COUNTER
WRITE_BYTE_TO_HREGS:
	MOVF POSTINC0, W ; get low byte of buffer data
	MOVWF TABLAT ; present data to table latch
	TBLWT+* ; write data, perform a short write
	; to internal TBLWT holding register.
	DECFSZ COUNTER ; loop until buffers are full
	BRA WRITE_BYTE_TO_HREGS		;WRITE_WORD_TO_HREGS _FF
	
	nop
	nop
	return 0

testasm:
	movlw 0xff
	movlb testvara
	movwf testvara,1
	movff testvara,POSTINC1
	call testa2
	MOVF POSTDEC1, F, ACCESS
	nop
	RETURN 0

testa2
	MOVFF FSR2, POSTINC1
	MOVFF FSR1, FSR2
	MOVF POSTINC1, F, ACCESS
	MOVLW 0xfe
	MOVF PLUSW2, W, ACCESS
	MOVWF INDF2, ACCESS
	NOP
	MOVF POSTDEC1, F, ACCESS
	MOVF POSTDEC1, F, ACCESS
	MOVFF INDF1, FSR2
	RETURN 0	


abs:
;vorspann
;	MOVFF FSR2L, POSTINC1
;	MOVFF FSR1L, FSR2L
;	MOVLW 0x4
;	ADDWF FSR1, F, ACCESS
;vorspann_ende


	movlb merker
	SETF merker,BANKED	;movlw 0xff
	RCALL p_to_fsr0

	MOVFF POSTINC0,abs_lo
	MOVFF POSTDEC0,abs_hi
	
	BCF STATUS,C,ACCESS
	movlb abs_lo
	comf abs_hi,F,BANKED
	NEGF abs_lo,BANKED
	BNC abs1
	incf abs_hi,F,BANKED
abs1:
	
	RCALL p_to_fsr0
	MOVFF abs_lo,POSTINC0	
	MOVFF abs_hi,POSTDEC0


	RETURN 0

float4li:
	;Stk2PushFromReg FSR2L		FSR2 sichern
	MOVFF FSR2L, POSTINC1
	MOVFF FSR2H, POSTINC1

	;Stk2CpyToReg -6,FSR2L		zeiger ASCII_string nach FSR2
	MOVLW 0xfa
	MOVFF PLUSW1, FSR2L
	MOVLW 0xfb
	MOVFF PLUSW1, FSR2H

	;StkCpyToReg -4,FSR0L		Wert Get_imput nach FSR0
;	movlb merker						
;	SETF merker,BANKED	;movlw 0xff
;	RCALL p_to_fsr0
	MOVLW 0xfc
	MOVFF PLUSW1,FSR0L
	MOVLW 0xfd
	MOVFF PLUSW1,FSR0H

	MOVFF POSTINC0,POSTINC1	;get_lo zwischenspeichern
	MOVFF POSTDEC0,INDF1;	POSTINC1	;get_hi

;	movlw 0xff;	get_hi
	BTFSS INDF1,7,ACCESS	;PLUSW1 ;get_hi
	GOTO _neg
neg:
	MOVLW '-';	Negatives Vorzeichen nach ASCII (FSR2)
	MOVWF POSTINC2,ACCESS

	comf INDF1,F,ACCESS	;get_hi

	BCF STATUS,C,ACCESS
	MOVLW 0xff
	NEGF PLUSW1,ACCESS	;get_lo
	BNC float4li0	
	incf INDF1,F,ACCESS	;get_hi
	
	BRA float4li0;	_neg berspringen

_neg:; kann man weglassen wenn kein positives Zeichen bentigt
	MOVLW '+';	Positives Vorzeichen nach ASCII
	MOVWF POSTINC2,ACCESS

float4li0:

;Platz fr BCD schaffen (float-Anteil)
;	MOVLW 0x07
;	ANDWF INDF1,F,ACCESS; vordere 5 Bit's zur Sicherheit lschen bei get_hi

	CLRF PREINC1, ACCESS;	BCD0 = lo HL	postinc0
	CLRF PREINC1, ACCESS;	BCD1 = hi HL	indf0
	
	MOVFF FSR1L,FSR0L
	MOVFF FSR1H,FSR0H

	MOVLW 0x04
	MOVWF PREINC1, ACCESS	;bit-zhler (indf1)

;	BCF STATUS, 0, ACCESS
jloop:

	BCF STATUS, 0, ACCESS; get_hi mit Nullen auffllen
	MOVLW 0xfd
	RRCF PLUSW1,F,ACCESS; get_hi fr spter nach get_lo schieben
	MOVLW 0xfc
	RRCF PLUSW1,F, ACCESS	;RRCF get_lo
	RRCF POSTDEC0, F, ACCESS	;rrcf BCD1
	RRCF INDF0, F, ACCESS		;rrcf BCD0

	RCALL byte1	;INDF0 BCD0
	MOVF POSTINC0,F,ACCESS	;BCD0 speichern

	RCALL byte1;	BCD1
 ;	MOVF POSTINC0,F,ACCESS	;BCD1 speichern

	DECF INDF1, F, ACCESS;	bit-zhler

	BNZ jloop

jend:
	MOVFF FSR0L,POSTINC1;	FSR0 sichern um nach btoa zurckzuschreiben
	MOVFF FSR0H,POSTINC1

	MOVFF FSR2L,POSTINC1;	Zeiger ascii bergeben
	MOVFF FSR2H,POSTINC1;	

	MOVLW 0xf8;				get_lo durch Schieben jetzt Integer
	MOVFF PLUSW1,POSTINC1;	get_lo fr btobcd bergeben	

	CALL btoa
	
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVFF POSTDEC1,FSR0H; FSR0 zurckschreiben
	MOVFF INDF1,FSR0L

loop_null:	;FSR2 auf Endemarkierung TEXT setzen
	MOVF PREINC2,F,ACCESS; auf null=endemarkierung testen
	BNZ loop_null

	MOVLW '.'; Dezimalpunkt
	MOVWF POSTINC2,ACCESS; schreiben

	RCALL ProcUpper
	RCALL ProcLower

	RCALL ProcUpper
	RCALL ProcLower

loop_nulltest	;schreibt die Endemarkierung und lscht die Nachkomma-nullen
	CLRF POSTDEC2;	Endemarkierung schreiben	indf2
;	MOVLW 0X30
;	SUBWF INDF2,W,ACCESS
;	BZ loop_nulltest
;	ADDWF 0x2,W,ACCESS	;0x30-0x02 = 0x2e ="." dezimalpunkt wegmachen
;	BZ loop_nulltest
	
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVF POSTDEC1,F,ACCESS
	MOVFF POSTDEC1,FSR2H; FSR2 zurckschreiben
	MOVFF INDF1,FSR2L

	RETURN 0


ProcUpper swapf     INDF0,W,ACCESS      ; upper nibble
          andlw     0x0F  
          addlw     0x30                ; make into ASCII
          movwf     POSTINC2,ACCESS     ; put it into string
          return

; Convert nibble to ASCII character
ProcLower movf      POSTDEC0,W,ACCESS   ; lower nibble
          andlw     0x0F  
          addlw     0x30                ; make into ASCII
          movwf     POSTINC2,ACCESS     ; put it into string
          return

byte1:
	MOVLW 0x3	;3
	SUBWF INDF0, W, ACCESS	;subwf
	BTFSC INDF0, 0x3, ACCESS
	MOVWF INDF0, ACCESS
	MOVLW 0x30	;0x30
	SUBWF INDF0, W, ACCESS	;subwf
	BTFSC INDF0, 0x7, ACCESS
	MOVWF INDF0, ACCESS
	RETLW 0

	end

;FSR1 
;get_lo	pointer
;get_hi	pointer
;FSR2L					0317
;FSR2H					0318
;bit-zhler

;FSR0
;BCD0	Nachkomma lo	301
;BCD1	Nachkomma hi	302

;FSR2
;String {vorz,3int,dezpunkt,4float,0}