#include "configuration.h"	//mu vor #include lcd.h stehen wegen LCD_SUPPORT = 1
#include "sw18b20.h"
#include "ds18b20_2.h"
#include "ds18b20_search2.h"
#include "inttypes.h"
#include "typedefs.h"
#include "lcd/lcd.h"
#include "hardware.h"
#include "main.h"
#include "ausg_LCD.h"

extern BYTE mr_byte;

uint8_t fu;

//uint8_t td10ms1;
//#define ti18b20	td10ms1 //timer0 Interrupt_Zeit
//extern uint8_t ti18b20;
uint8_t ds18b20_LCD;

uint8_t i0;	// i,j ist in LCD definiert

uint8_t id[8];
uint8_t diff;
uint8_t sn_anz;
uint8_t x10,y10;
char sr_1[10]; // fr ASCII Anzeige ("-012.3456";)

char sn_liste[sn_max][8];
 //char sn_alm_liste[sn_max][8];
char get0[10]; //scratchpad RAM (temp LSB, temp MSB, TH, TL, Config,rev5678, CRC)
char alw[sn_max][3];  //Byte TH,TL,Config
char temp[sn_max];
WORD temp_int[sn_max];
uint8_t fuehl[sn_max];

unsigned char search;

/*
typedef enum {
	ds18b20Conv =0,
	ds18b20Tread,
	ds18b20ToutInit_LCD,
	ds18b20Tout_LCD,  
	ds18b20EEoutInit,
	ds18b20EEout
}ds18b20CMD_t;
*/

ds18b20CMD_t ds18b20CMD = ds18b20Conv;


void ds18b20int (void)
{
//		if (ti18b20==0) switch(ds18b20CMD) //abfrage in main.c
		switch(ds18b20CMD)
		{	
			case ds18b20Conv:	//Temperatur einlesen vorbereiten
					//ow_sn(0); //0 nicht sn, damit skipt (alle convertiert werden)
                    ow_reset();
                    write_byte(Skip_Rom);
                    
					write_byte(Convert_T);
					fu=0;	//bei Fhler 0 anfangen
					ti18b20 =80;	//750ms warten bis Convert fertig
                    
                    if(ds18b20_LCD<2){
                        ds18b20CMD = ds18b20ToutInit_LCD;
                    }
                    else {
                        ds18b20CMD = ds18b20Tread;
                    }

					//ds18b20CMD = ds18b20ToutInit_LCD;
                    //ds18b20_LCD =0xff;  //(keine LCD)
                    /*
                    ds18b20CMD = ds18b20ToutInit_LCD;//nur wenn eine folgende Bedingungen erfllt ist
                    if(aktAnz[0]==ausg_ds18b20temp)
                        ds18b20_LCD=0;
                    else if(aktAnz[1]==ausg_ds18b20temp) 
                        ds18b20_LCD=1;
                    else 
                        ds18b20CMD = ds18b20Tread;// beide Bedingungen nicht erfllt
                    */
 				break;
			
			case ds18b20Tread:
					ow_sn(sn_liste[fu]);
					get0[0] = get0[1] = 0xff;	//-1C lschen zum Testen falls Read_ScratchPad nicht ausgefhrt wird (keine korekte SN)
					Read_ScratchPad(get0);
					temp[fu] = ((get0[0] & 0xf0)>>4) | ((get0[1] & 0x0f)<<4);	//aktuelle Temperatur (ganzzahl) sichern

					/********** 16 Bit Zahl merken *************/
					temp_int[fu].byte0 = get0[0];
					temp_int[fu].byte1 = get0[1];

					fu++;
					if (fu<sn_anz) 	ti18b20 = 20; //Zeit setzen und hier bleiben 
					else{
						ti18b20 = 250;
						ds18b20CMD = ds18b20Conv;	//next bzw neu anfangen
					}
				break;

			case ds18b20ToutInit_LCD:	//Tout init
                if(ds18b20_LCD > 1){    //eingefgt 12.01.25 wegen Absturz
                    fu = 0; // bei Fhler 0 anfangen nach nderung der Ausgabe
                    ds18b20CMD = ds18b20Tread;
                    break;
                }
                    lcd_neu = ds18b20_LCD; LCD_ausw();
					LCD_Control_noBF(1);	//ClrHome ohne Wartezeit
					x10=0; y10=0; 

					ti18b20 =2;		//10ms warten wegen ClrHome
					ds18b20CMD = ds18b20Tout_LCD;
				break;
	
			case ds18b20Tout_LCD: //alle Temperaturwerte ausgeben, convert war vorher  //fu = fhler (j0)
                if(ds18b20_LCD > 1){    //eingefgt 12.01.25 wegen Absturz
                    fu = 0; // bei Fhler 0 anfangen nach nderung der Ausgabe
                    ds18b20CMD = ds18b20Tread;
                    break;
                }
                    lcd_neu = ds18b20_LCD; LCD_ausw();//&& logisch, & bitweise
					if ((x10==0)&&(y10>3)) {y10=3; LCD_scr_up();}	//hier erst Scrollen, damit noch Zeit zum Lesen x10 wurde unten auf 0 gesetzt
					ow_sn(sn_liste[fu]);
					get0[0] = get0[1] = 0xff;	//-1C lschen zum Testen falls Read_ScratchPad nicht ausgefhrt wird (keine korekte SN)
					Read_ScratchPad(get0);

					temp_int[fu].byte0 = get0[0];
					temp_int[fu].byte1 = get0[1];

					temp[fu] = ((get0[0] & 0xf0)>>4) | ((get0[1] & 0x0f)<<4);	//aktuelle Temperatur (ganzzahl) sichern

//if(mode==3) {get0[0]=0x7b;get0[1]=1;}	//23.6875 C


/*
					temp_int[fu] = (unsigned int) get0[0] <<8;
					temp_int[fu] |= get0[1];

*/
					/********** 16 Bit Zahl merken *************
					temp_int[fu] = get0[0];      			// low byte
    				temp_int[fu] |= ((unsigned int)get0[1] << 8);    // high byte
					*******************************************/

					float4li(get0,sr_1); //*sr_1
					LCD_gotoxy(x10,y10);	//evtl weg, siehe unten

					ausg8b(get0[2]);		//Th (SN_F) Register ausgeben 
					LCD_Out(' ');

					sr_1[6]=0;		//Byte 6=0 Endemarkierung Text (6 Zeichen)
					LCD_string(sr_1);
					fu++;	//hier

					if (fu<sn_anz) 
					{
						if(x10==10)
						{
							x10=0;y10++;	
							if (y10>3) 
							{
//	###							y10=3; LCD_scr_up();	//am Anfang eingefgt
								ti18b20 = 100;		//bei mehr als 4 Zeilen 1sec warten
							}
						}
						else 
						{
							x10=10;
							ti18b20 = 20;
						}	
						//ds18b20CMD = ds18b20Tout_LCD;		//hier bleiben
					}
					else 
					{
						//fu=0;	//nicht umbed. ntig, in Temp_einlesen vorbereiten
						ti18b20 = 250;
						ds18b20CMD = ds18b20Conv;	//next bzw neu anfangen
					}
				break;

			case ds18b20EEoutInit:		//wird nicht gebraucht?
					LCD_Control_noBF(1);	//ClrHome ohne Wartezeit
					x10=0; y10=0;
					fu=0;

					ti18b20 = 2;	//10ms Wartezeit wegen ClrHome
					ds18b20CMD = ds18b20EEout;
				break;


			case ds18b20EEout:	
					LCD_gotoxy(x10,y10);
					for (i0=0;i0<3;i0++)
					{
						ausg8b(alw[fu][i0]);
					}
					if(x10==10)
					{
						x10=0;y10++;
					}
					else x10=10;

					if (fu<sn_anz-1) 
					{
						fu++;
						ti18b20 = 1;
						// ds18b20CMD = ds18b20EEout;		//hier bleiben
					}
					else 
					{
						//fu=0;	//nicht umbed. ntig, bei Init vorhanden
						ti18b20 = 255;		//2,55s warten damit lesbar 
						ds18b20CMD = ds18b20Conv;	//next bzw neu anfangen
					}
				break;

/*	
			case ds18b20EEout:		//wird nicht gebraucht?

				{
					x10=0; y10=0;
		
					for (j0=0;j0<32;j0++)
						SleepMs(250);
		
					LCD_Control(1);
					for (fu=0;fu<sn_anz;fu++)
					{
						LCD_gotoxy(x10,y10);
						for (i0=0;i0<3;i0++)
						{
							ausg8b(alw[fu][i0]);
						}
						if(x10==10)
						{
							x10=0;y10++;
						}
						else x10=10;
					}
		
					for (j0=0;j0<8;j0++)
						SleepMs(250);
				}
				break;
*/
		}	
}
/********************************************************************************************************/
/* mu noch gendert werden */
/********************************************************************************************************/

void Init_18b20(void)
{
	for (i0=0;i0<sn_max;i0++) fuehl[i0]=255;	//Fhler setzen
	for (i0=0;i0<sn_max;i0++) temp_int[i0]._word=32768; 	//Temperatur setzen
	ds18b20_suchen ();
//	if (!PORTEbits.RE3) WR_alle_Scratchpad(); //gibt jeden Fhler eine Nummer und speichert diese im EEProm des Fhlers
	RD_alle_Scratchpad(); //liest von jeden Fhler das EEProm und speichert die Werte in alw[][]

	ti18b20=200;	//2 sec warten	
	ds18b20CMD = ds18b20Conv; //bei Convert anfangen
}	

void ds18b20_suchen(void){

//	writeLCDRomString("Suchen Anf");
	fu = 0;
	for(diff = 0xff; diff !=0;fu++ ){ //=OW_SEARCH_FIRST	!=OW_LAST_DEVICE)
 		diff = ow_rom_search_ff(diff,&id[0],Search_Rom); //bool
        if (diff >=0xfe) break; //zum Testen eingefgt
        //if(aktAnz[0]==ausg_ds18b20sn){  //gefunden SN ausgeben Anz0
        //    ausg8b(diff); LCD_Out(' ');   
            for (i0=0;i0<8;i0++){
                sn_liste[fu][i0] = id[i0];
                //ausg8b(id[i0]); //SN ausgeben
            }
            //LCD_cr();   //leerzeile fr neue SN
        //}
	}
	sn_anz= fu;
 //   lcd_neu=1; LCD_ausw();  //Fhler gefunden auf LCD1 danach auch Version hier
//	ausg8b(sn_anz); LCD_Out(' '); writeLCDRomString("Fuehler gefunden");
///	SleepMs(255);
}

void WR_alle_Scratchpad(void)	//gibt jeden Fhler eine Nummer und speichert diese im EEProm des Fhlers
{
	writeLCDRomString("Fuehler init");
	for (fu=0;fu<sn_anz;fu++)
	{
		ow_sn(sn_liste[fu]);	
		write_byte(Write_Scratchpad);
		write_byte(fu);			//byte 0	th 	durchgehende Nummer
		write_byte(0xff);		//byte 1	tl	Reserve
		write_byte(0x3f);		//byte 2	config (nur bit 5-6 beschreibar) 0x3f ist 10 Bit Auflsung
		//delay wird  in write_bit erledigt?
		ow_sn(sn_liste[fu]);	
		write_byte(Copy_Scratchpad); //Kopiert Werte ins EEProm
		//evtl bit speichern um zu zhlen
	}
	ti18b20 = 255;		//2,55s warten damit lesbar 
//	SleepMs(255);
}

void RD_alle_Scratchpad(void)	//liest von jeden Fhler das EEProm und speichert die Werte in alw[][]
{
//	writeLCDRomString("RD_alle_Spd.");
	for (fu=0;fu<sn_anz;fu++)
	{
//		get0[2]=sn_max;	//initialisieren falls kein Fhler da
		ow_sn(sn_liste[fu]);	
		write_byte(Recall_EE);

/*
		write_byte(j0);			//byte 0	th 	durchgehende Nummer
		write_byte(temp[j0]-5);	//byte 1	tl	Reserve
		write_byte(0x7f);		//byte 2	config (nur bit 5-6 beschreibar)
*/
		wait_10us(12);	//tmr3Us(120);
		ow_sn(sn_liste[fu]);

		Read_ScratchPad(get0);
		for (i0=0;i0<3;i0++)
			alw[fu][i0] = get0[i0+2];	//Byte 2 bis 4 sichern
		fuehl[get0[2]]=fu;
	}
}

void sn_liste_out(void){
    uint8_t fu; //neu definieren, damit anderes fu nicht berschrieben wird
    stdOut_mr = stdOut; //vorsichtshalber sichern
    stdOut = source_lcd;
    for (fu=0;fu<sn_anz;fu++){
        printOut("%x ",alw[fu][0]);
		for (i0=0;i0<8;i0++){
            printOut("%x",sn_liste[fu][i0]);
        } 
        LCD_cr();
    }
stdOut =stdOut_mr;  //vorsichtshalber zurckschreiben
}
