/**
 *******************************************************************
 * Lesson 3 - "Rotate"
 *
 * This lesson will introduce shifting instructions as well as bit-oriented skip operations to
 * move the LED display.
 *
 * LEDs rotate from right to left at a rate of 1.5s
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 18.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                //PIC hardware mapping
#include <xc.h>                 //PIC hardware mapping
#define _XTAL_FREQ 500000       //Used by the compiler for the delay_ms(x) macro

//VSK moved config bits to PICkit_3_Starter_Config.c

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

void main(void) {
    TRISC = 0;                  //all pins are outputs
    OSCCON = 0b00100010;        //500KHz clock speed
    LATC = 0b0001000;           //start with DS4 lit by setting bit 3 HIGH in LATC

    while (1) {
            __delay_ms(500);    //delay 500ms
//VSK            LATC >> = 1;        //shift to the right by 1
            LATC = LATC >> 1;        //shift to the right by 1
            if(STATUSbits.C)    //when the last LED is lit, restart the pattern
                LATCbits.LATC3 = 1;
    }

}