/**
 *******************************************************************
 * Lesson 4 - "Analog to Digital"
 *
 * This shows how to read the A2D converter and display the
 * High order parts on the 4 bit LED display.
 * The pot on the Low Pin Count Demo board varies the voltage
 * coming in on in A0.
 *
 * The A2D is referenced to the same Vdd as the device, which
 * is nominally is 5V.  The A2D returns the ratio of the voltage
 * on Pin RA0 to 5V.  The A2D has a resolution of 10 bits, with 1023 
 * representing 5V and 0 representing 0V.
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 18.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                         //PIC hardware mapping
#include <xc.h>                          //PIC hardware mapping
#define _XTAL_FREQ 500000                //Used by the compiler for the delay_ms(x) macro

//VSK moved config bits to PICkit_3_Starter_Config.c

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */


void main(void) {
    OSCCON = 0b00100010;                 //500KHz clock speed
    TRISC = 0;                           //all LED pins are outputs


    TRISAbits.TRISA4 = 1;                //Potentiamtor is connected to RA4...set as input
    ANSELbits.ANS3 = 1;                  //analog input - different than pic16 syntax
    ADCON0 = 0b00001101;                 //select RA4 as source of ADC, which is AN3, and enable the module
    ADCON2 = 0b00000001;                 //left justified - FOSC/8 speed

    while (1) {
        __delay_us(5);                  //wait for ADC charging cap to settle
        ADCON0bits.GO = 1;
        while (ADCON0bits.NOT_DONE) continue;   //wait for conversion to be finished
        LATC = (ADRESH >> 4);           //grab the top 4 MSBs
    }



}