/**
 *******************************************************************
 * Lesson 1 - "Hello World"
 *
 * The LEDs are connected to input-outpins (I/O) RC0 through RC3. First, the I/O pin
 * must be configured for an output. In this case, when one of these pins is driven high
 * (RC0 =  1 ), the LED will turn on. These two logic levels are derived from the power pins
 * of the PIC MCU. Since the PIC device?s power pin (VDD) is connected to 5V and the
 * source (VSS) to ground (0V), a '1' is equivalent to 5V, and a '0' is 0V.
 *
 * This turns on DS1 LED on the Low Pin Count Demo Board.
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 18.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                //PIC hardware mapping
#include <xc.h>                 //PIC hardware mapping

//VSK moved config bits to PICkit_3_Starter_Config.c

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */


//Every program needs a `main` function
void main(void) {
    TRISCbits.TRISC0 = 0;       //using pin as output
    LATC = 0;                   //init to zero
    LATCbits.LATC0 = 1;         //turn on the LED by writing to the latch
    while(1) continue;          //sit here forever doing nothing. Read this as, "While(TRUE), continue in this loop"
}