/**
 *******************************************************************
 * Lesson 5 - "Variable Speed Rotate"
 *
 * This lesson combines all of the previous lessons to produce a variable speed rotating
 * LED display that is proportional to the ADC value. The ADC value and LED rotate
 * speed are inversely proportional to each other.
 *
 * Rotate the POT counterclockwise to see the LEDs shift faster.
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 18.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                         //PIC hardware mapping
#include <xc.h>                          //PIC hardware mapping
#define _XTAL_FREQ 500000                //Used by the compiler for the delay_ms(x) macro

//VSK moved config bits to PICkit_3_Starter_Config.c


unsigned char adc(void); //prototype

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

void main(void) {
    unsigned char delay;                 //8 bit variable to hold ADC value (top 8 bits...forget the rest)

    OSCCON = 0b00100010;                 //500KHz clock speed
    TRISC = 0;                           //all LED pins are outputs
    LATC = 0b0001000;                    //start with DS4 lit by setting bit 3 HIGH in LATC
    TRISAbits.TRISA4 = 1;                //Potentiamtor is connected to RA4...set as input
    ANSELbits.ANS3 = 1;                  //analog input - different than pic16 syntax
//VSK    ADCON0 = 0b00001101;                 //select RA4 as source of ADC, which is AN3, and enable the module
//VSK    ADCON2 = 0b00000001;                 //left justified - FOSC/8 speed
    ADCON1bits.PVCFG = 0;       //VDD
    ADCON1bits.NVCFG = 0;       //VSS (GND)
    ADCON2bits.ADFM = 0;        //left justified
    ADCON2bits.ACQT = 0b000;    //0TAD automatic aquisition time
    ADCON2bits.ADCS = 0b001;    //FOSC/8 speed  -> TAD 8/500kHz = 16us
    ADCON0bits.CHS = 3;
    ADCON0bits.ADON = 1;
    
    while (1) {
        delay = adc();                  //grab the top 8 MSbs
        __delay_ms(5);                  //delay for AT LEAST 5ms
        while (delay-- != 0){           //for each value of the ADC value, delay 2ms
            __delay_ms(2);
        }                                //decrement the 8 MSbs of the ADC and dealy 2ms for each
//VSK        LATC >> = 1;                     //shift to the right by 1
        LATC = LATC >> 1;                //shift to the right by 1
        if (STATUSbits.CARRY)            //when the last LED is lit, restart the pattern
            LATCbits.LATC3 = 1;          //NOTE:
                                         //In 'C', a value of 0 represents FALSE.
                                         //Any non zero (including negative numbers) value represents TRUE
    }
}

unsigned char adc(void) {
//VSK    __delay_us(5);                  //wait for ADC charging cap to settle
//VSK always same channel here and function call waste lot of time anyway
    ADCON0bits.GO = 1;
    while (ADCON0bits.NOT_DONE) continue;//wait for conversion to be finished
    return ADRESH;
}