/**
 *******************************************************************
 * Lesson 6 - "Debounce"
 *
 * This lesson uses a simple software delay routine to avoid the initial noise on the switch
 * pin. The code will delay for only 5 ms, but should overcome most of the noise. The
 * required delay amount differs with the switch being used. Some switches are worse
 * than others.
 *
 * This lesson also introduces the  #define preprocessing symbol in both 'C' and assembly.
 * Hard coding pin locations is bad practice. Values that may be changed in the future
 * should always be defined once in preprocessing. Imagine if another user wanted to use
 * these lessons in a different PIC device and all of the pins changed! This would require
 * going into the code and finding every instance of any pin reference.

 * When the switch is held down, DS1 will be lit. When the switch is not held down, all
 * LEDs are OFF.
 *
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 19.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                         //PIC hardware mapping
#include <xc.h>                         //PIC hardware mapping
#define _XTAL_FREQ 500000               //Used by the compiler for the delay_ms(x) macro

/**
 * These #define statements are useful for pin assignments as well as common definitions
 */
#define DOWN        0
#define UP          1
#define SWITCH      PORTAbits.RA2
#define LED         LATCbits.LATC0

//VSK moved config bits to PICkit_3_Starter_Config.c

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

void main(void) {
    OSCCON = 0b00100010;                //500KHz clock speed
    TRISAbits.TRISA2 = 1;               //switch input
    ANSELbits.ANS2 = 0;                 //digital input
    TRISC = 0;                          //all LED pins are outputs
    LATC = 0;                           //start with all LEDs OFF

    while (1) {
        if (SWITCH == DOWN) {           //switch is normally open to 5V ...when pressed, RA3 is connected to GND
            __delay_ms(10);             //debounce by delaying and checking if switch is still pressed
            if (SWITCH == DOWN) {       //check if still down
                LED = 1;                //turn on DS1
            }
        }
        else
            LED = 0; //constantly turn DS1 off if it is not pressed
    }

}