/**
 *******************************************************************
 * Lesson 8 - "PWM"
 *
 * Pulse-Width Modulation (PWM) is a scheme that provides power to a load by switching
 * quickly between fully on and fully off states. The PWM signal resembles a square wave
 * where the high portion of the signal is considered the on state and the low portion of
 * the signal is considered the off state. The high portion, also known as the pulse width,
 * can vary in time and is defined in steps. A longer, high on time will illuminate the LED
 * brighter. The frequency or period of the PWM does not change. A larger number of
 * steps applied, which lengthens the pulse width, also supplies more power to the load.
 * Lowering the number of steps applied, which shortens the pulse width, supplies less
 * power. The PWM period is defined as the duration of one complete cycle or the total
 * amount of on and off time combined.
 *
 * Rotating the POT will adjust the brightness of a single LED, DS4
 *
 * PIC: 18F14K22
 * Compiler: XC8 v1.00  VSK 2.46
 * IDE: MPLABX v1.10    VSK 6.20
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012       VSK 19.09.25
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

//VSK #include <htc.h>                         //PIC hardware mapping
#include <xc.h>                          //PIC hardware mapping
#define _XTAL_FREQ 500000               //Used by the compiler for the delay_ms(x) macro

//VSK moved config bits to PICkit_3_Starter_Config.c

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

void main(void) {
    OSCCON = 0b00100010;                //500KHz clock speed
    TRISC = 0;                          //all LED pins are outputs
    LATC = 0;

    //setup the ADC
    TRISAbits.TRISA4 = 1;               //Potentiamtor is connected to RA4...set as input
    ANSELbits.ANS3 = 1;                 //analog input - different than pic16 syntax
    ADCON0 = 0b00001101;                //select RA4 as source of ADC, which is AN3, and enable the module
    ADCON2 = 0b00000001;                //left justified - FOSC/8 speed

    //setup the PWM for 489Hz...anything over 60Hz will not produce noticeable flicker
    CCP1CON = 0b01001100;               //PWM mode - select DS3 as output LED
    PR2 = 255;                          //CCP1 always uses TMR2
                                        //PWM Period = [PR2 + 1]*4*Tosc*T2CKPS = [255 + 1] * 4 * (1 / 500KHz) * 1 = ~489Hz
    T2CONbits.T2CKPS = 0b00;            //1:1 prescaler
    T2CONbits.TMR2ON = 1;               //start the PWM

    while (1) {
//VSK        __delay_us(5);                  //wait for ADC charging cap to settle
//VSK        GO = 1;                         //start the ADC conversion
        ADCON0bits.GO = 1;
        while (ADCON0bits.NOT_DONE) continue;//wait for conversion to be finished
        CCPR1L = ADRESH;                //put the top 8 MSbs into CCPR2L
        CCP1CONbits.DC1B = (ADRESL >> 6);//put the 2 LSbs into DC2B register to complete the 10bit resolution
                                        //must shift to the right by 6 places since the ADC result is LEFT justified
    }
}
