/*
 * File:   main.c
 * Author: volker
 *
 * Created on 24. Oktober 2019, 20:41
 */


#include <xc.h>

#pragma config FOSC = INTIO67
#pragma config WDTEN = OFF
#pragma config MCLRE = EXTMCLR
#pragma config LVP = OFF

void __init(void);

void main(void)
{
    __init();

    while (1) {
        ADCON0bits.GO = 1;                  // start conversion
        while (ADCON0bits.NOT_DONE) {;}     // wait for comple
        LATD = ADRESH;
    }
}

void __init(void)
{
    OSCCONbits.IRCF = 0b011;
    OSCTUNEbits.PLLEN = 0;      // -> 1MHz (default)
    
    TRISD = 0x00;               // mALL_LED_OUTPUT();
    TRISAbits.TRISA0 = 1;       // POTI_TRI = INPUT_PIN;
    ANSELAbits.ANSA0 = 1;       // POTI_ANS = ANALOG_IN;
    ADCON0bits.CHS = 0;         // poti is connected to analog channel 0
    ADCON1bits.NVCFG = 0;       // ADref- connected to AVss (GND)
    ADCON1bits.PVCFG = 0;       // ADref+ connected to AVdd ()
    ADCON2bits.ADCS = 0;        // Tad = 1/(Fosc/2) = 2us
    ADCON2bits.ACQT = 0b010;    // 4*Tad = 8us
    ADCON2bits.ADFM = 0;        // left -> 8 most significant bits in ADRESH
    ADCON0bits.ADON = 1;        // switch on ADC module
}