#include "menu.h"
#include "inttypes.h"//#include "typedefs.h"
#include "lcd/lcd.h"
#include "hardware.h"
//#include "main.h"
#include "schalter.h"
#include "adc.h"
#include "main.h"   //wegen global schalterabfr und timerflag
#include "JSONDataReader.h"
#include "emsProtokoll.h"
//#include "emsCommand.h"

//extern void ausg16b(word);
//extern void ausg12b(word);
//extern void ausg8b(uint8_t byte);

//extern LCD_t LCD0;
//extern LCD_t LCD1;
//extern uint8_t lcd_neu;

#define crsrMinY 0
#define crsrMaxY 3

#define ausw_max 10 //0..10

uint8_t value_ausw_laeuft=0;
uint8_t Displ_ausw_anfang =0;
//uint8_t ausw_aktuell =0;
uint8_t crsrY_aktuell =0;

uint8_t value_min;
uint8_t value_max;
uint8_t value_def;
uint8_t ausw_cmd;

extern uint8_t timer100ms1;

typedef enum test{
    hk2_schpr,
    hk2_pause, 
    hk2_party,
    hk2_tag,
    hk2_nacht,
    hk2_betr,
    ww_solltemp,
    ww_betr,
    ww_einmal,
    zp_betr,
    uba_max_leist   //0..10       
 //   anz_felder
    }
    ausw_menu_t;
    
ausw_menu_t ausw_aktuell=hk2_schpr; //0
menu_ems_buffer_t menu_ems_buffer[buffer_size];

void ausw_mark(uint8_t zeile);
void ausw_delmark(uint8_t zeile);

//https://learntutorials.net/de/c/topic/4547/initialisierung
//int array[] = { [4] = 29, [5] = 31, [17] = 101, [18] = 103, [19] = 107, [20] = 109 };

const rom char menu_txt[ausw_max+1][18] = {
    "HK2 Schaltprogr.",  //0
    "HK2 Pause",
    "HK2 Party",
    "HK2 Temp Tag",
    "HK2 Temp Nacht",
    "HK2 Betr. Art",
    "WW Solltemp",
    "WW Betr. Art",
    "WW Einmalladung",
    "ZP Betriebsart",
    "UBA MAX Leistung"  //0..10
};

uint8_t displ_laeuft;

#pragma code

void ausw_mark(uint8_t zeile){
 	LCD_gotoxy(0,zeile);
	writeLCDData('<');
	LCD_gotoxy(19,zeile);
	writeLCDData('>');   
}

void ausw_delmark(uint8_t zeile){
   	LCD_gotoxy(0,zeile);
	writeLCDData(' ');
	LCD_gotoxy(19,zeile);
	writeLCDData(' ');     
}

void display_menu(void)
{
	uint8_t i;
	uint8_t crsrYauswPos;

	crsrYauswPos = Displ_ausw_anfang;
	for (i=crsrMinY; i<crsrMaxY+1; i++){
        LCD_delline(i);
		if (crsrY_aktuell==i){
            ausw_mark(i);
		}
		LCD_gotoxy(1,i);
		writeLCDRomString(menu_txt[crsrYauswPos]);
		if(crsrYauswPos < ausw_max) crsrYauswPos ++;
			else crsrYauswPos = 0; 
	}
}
		

void menu_crsr_down (void)
{
	ausw_delmark(crsrY_aktuell);
	
	if (ausw_aktuell < ausw_max){
		ausw_aktuell ++;
	}else
		ausw_aktuell = 0;
	if (crsrY_aktuell  <  crsrMaxY){
		crsrY_aktuell ++;
        LCD_delline(crsrY_aktuell);
		LCD_gotoxy(1,crsrY_aktuell);
		writeLCDRomString(menu_txt[ausw_aktuell]);
        ausw_mark(crsrY_aktuell);		
		}	
		else
			{
			Displ_ausw_anfang ++;
            if(Displ_ausw_anfang>ausw_max)
                Displ_ausw_anfang=0;
			display_menu();
			}
}
	
			

void menu_crsr_up (void)
{
	ausw_delmark(crsrY_aktuell);
	
	if (ausw_aktuell > 0){
		ausw_aktuell --;
	}else
		ausw_aktuell = ausw_max;
	if (crsrY_aktuell  >  crsrMinY){
		crsrY_aktuell --;
        LCD_delline(crsrY_aktuell);
		LCD_gotoxy(1,crsrY_aktuell);
		writeLCDRomString(menu_txt[ausw_aktuell]);
        ausw_mark(crsrY_aktuell);		
		}	
		else{
            if(Displ_ausw_anfang>0)
                Displ_ausw_anfang --; 
            else
                Displ_ausw_anfang=ausw_max;
			display_menu();
		}
}	
     
void menu_auswerten(void){
    uint8_t i;
    value_ausw_laeuft=1;
    writeLCDCmd(LCD_CLEARDISPLAY);
    writeLCDRomString(menu_txt[ausw_aktuell]);
    switch (ausw_aktuell) {
        case hk2_schpr: //HK2 Schaltprogr
            value_def =0;
            value_min =0;
            value_max =10;
            ausw_cmd = HK2SchaltProg;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
        case hk2_pause: //HK2 Pause
            value_def =0;
            value_min =0;
            value_max =90;
            ausw_cmd = HK2Pause;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
        case hk2_party: //HK2 Party
            value_def =0;
            value_min =0;
            value_max =90;
            ausw_cmd = HK2Party;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);            
            break;
        case hk2_tag: //
            value_def =23;
            value_min =11;
            value_max =30;
            ausw_cmd = HK2RaumTag;
            menu_value();
            value_def *=2;
            //jsonCommand(ausw_cmd,value_def);
            break;
        case hk2_nacht: 
            value_def =10;
            value_min =10;
            value_max =29;
            ausw_cmd = HK2RaumNacht;
            menu_value();
            value_def *=2;
            //jsonCommand(ausw_cmd,value_def);
            break;
        case hk2_betr: 
            value_def =0;
            value_min =0;
            value_max =2;
            ausw_cmd = HK2BetrArt;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
        case ww_solltemp: 
            value_def =37;
            value_min =10;
            value_max =65;
            ausw_cmd = WWTmpSollSet;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
        case ww_betr: 
            value_def =0;
            value_min =0;
            value_max =2;
            ausw_cmd = WWBetrArt;
            //jsonCommand(ausw_cmd,value_def);
            menu_value();
            break;
        case ww_einmal: //start=35 stop3 (dez)	
            value_def =35;
            //value_min =3;
            //value_max =35;
            ausw_cmd = WWEinmalladung;
            //jsonCommand(ausw_cmd,value_def);
            //menu_value();
            displ_laeuft = 0;   //weil nicht nenu_value aufgerufen wird
            break;
        case zp_betr: 
            value_def =0;
            value_min =0;
            value_max =2;
            ausw_cmd = ZPBetrArt;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
        case uba_max_leist: 
            value_def =25;
            value_min =20;
            value_max =100;
            ausw_cmd = UBAmxKLeist;
            menu_value();
            //jsonCommand(ausw_cmd,value_def);
            break;
    }
    writeLCDCmd(LCD_CLEARDISPLAY);
    display_menu();
 }

void menu_value(void){
    uint8_t inp_sch;
 //   steht schon in auswerten   
    writeLCDCmd(LCD_CLEARDISPLAY);
    writeLCDRomString(menu_txt[ausw_aktuell]);
    
	while (value_ausw_laeuft){
        LCD_gotoxy(0,1);
        hex_dec_ausg(value_def);
       
        
        if (inp_a0w){
            inp_a0w=0;
            if (value_def>value_min) value_def--;
         }
        
        if (inp_a1w){
            inp_a1w=0;
            if (value_def<value_max) value_def++;
        }
        
        if (inp_an4w){
            inp_an4w=0;
            value_ausw_laeuft = 0;
        }
        //LCD_gotoxy(15,0);
        //writeLCDHex(ausw_aktuell);
	}// ende von while
    writeLCDCmd(LCD_CLEARDISPLAY);
    writeLCDRomString(menu_txt[ausw_aktuell]);
    LCD_gotoxy(0,1);
    writeLCDHex(ausw_cmd);
    LCD_gotoxy(5,1);
    hex_dec_ausg(value_def);
    LCD_gotoxy(0,2);
    LCD_Out(0xf5); writeLCDRomString("bernommen");
    //sendEmsCommand( BUS_ADR_RC35, HK2_SCHALTZEIT, 0x55, value_def );
    //jsonCommand(ausw_cmd,value_def);
    displ_laeuft = 0;
 //   input_schalter(inp_sch);
 //   inp_sch=0;

    writeLCDCmd(LCD_CLEARDISPLAY);
 //   display_menu();
}

void menu_init(void){
//	uint8_t displ_laeuft;
    uint8_t input_sch;
    uint8_t i;
     
    writeLCDCmd(LCD_CLEARDISPLAY);

	displ_laeuft =1;
    
	Displ_ausw_anfang =0;
	ausw_aktuell =0;
	crsrY_aktuell =0;
	display_menu();
    
	while (displ_laeuft){
        if (inp_a0w){
            inp_a0w=0;
            menu_crsr_down();
        }
        if (inp_a1w){
            inp_a1w=0;
            menu_crsr_up();
        }
        
        if ((inp_an4w>0)&&(inp_an4w<11)){
            inp_an4w=0;
            menu_auswerten();
        }
        if (inp_an4w>10){
            inp_an4w=0;
            displ_laeuft = 0;
        }
	}// ende von while
    writeLCDCmd(LCD_CLEARDISPLAY);
    timer100ms1 =0; TimerFlag.IF10s=0;//wegen timerflag 10s
    //LCD_Control(0x01);  //clear Display
}

void buffer_leeren (void){
    uint8_t i;
    for (i=0;i<buffer_size;i++)
        menu_ems_buffer[i].ems_bef =0;
}

void buffer_lesen(void){
    uint8_t i;
    uint8_t zeit_10min;
    uint8_t gef;
    
    for (i=0;i<buffer_size;i++){
        if (menu_ems_buffer[i].zeit_10m== zeit_10min){
            menu_ems_buffer[i].ems_bef =0;
            gef=1;
        }
    }
}

void buffer_schreiben(void){
    uint8_t i;
    menu_ems_buffer_t schreibe;
    
    for (i=0;menu_ems_buffer[i].ems_bef ==0 || i<buffer_size;i++);
    if(i< buffer_size){
         menu_ems_buffer[i] = schreibe; //ende
    }
 //   else //buffer voll
        
 }
    
