;..................................
; PIC: 18F14K22//Assembler:MPASM V5.43//IDE: MPLABX v3.55//PICkit3 Demo Board
;               
;port a: a0-a5 (6x), port b: b4-b7 (4x), port c: c0-c7 (8x)       
;
;      Port A: a2 als eingang fr analoge messspannung
;	      	
;      Port B: alle 4 auf ausgang/
;           
;           b7: out beeper 
;
;      Port C: alle 7 auf ausgang
;           c4: led1 
;           c5: led2
;           c6: led3
;           
;
#include <p18F14K22.inc>

    ;Config settings
    CONFIG IESO = OFF, PLLEN = OFF, FOSC = IRC, FCMEN = OFF, PCLKEN = OFF
    CONFIG BOREN = OFF, BORV = 19, PWRTEN = OFF, WDTEN = OFF
    CONFIG MCLRE = ON, HFOFST = OFF, DEBUG = OFF, STVREN = ON
    CONFIG XINST = OFF, BBSIZ = OFF, LVP = OFF
    CONFIG CP0 = OFF, CP1 = OFF
    CONFIG CPD = OFF, CPB = OFF
    CONFIG WRT0 = OFF, WRT1 = OFF
    CONFIG WRTB = OFF, WRTC = OFF, WRTD = OFF
    CONFIG EBTR0 = OFF, EBTR1 = OFF
    CONFIG EBTRB = OFF

    errorlevel -302      ;surpress the 'not in bank0' warning

GPR_VAR         UDATA	
adclow          RES     1
adchigh         RES     1
bitlow          RES     1      
bithigh         RES     1
;...................................
	 
     Org 0x0000			;kein reset vector
     bra    START

MAIN_PROG   CODE

START:                          ;Setup main init
     movlw      b'00000010'     ;set cpu clock speed of 31KHz
     movwf      OSCCON          ;move contents of working register into OSCCON
     clrf       OSCTUNE         ;
     clrf       LATA
     movlw      b'00000101'     ;port a0 und a2 eingang, der rest auf ausgang
     movwf      TRISA     
     movlw      b'00000101'     ;a0, a2 analog,die anderen digital buffer enabl
     movwf      ANSEL           ;analog eingang: dig buffer disabled
     movwf      WPUA            ;wake up an A2 enabled
     movlw      b'00001001'     ;select ra2 as souce of adc and enable module
     movwf      ADCON0
     movlw      b'10000001'     ;right justified-Fosc/8 speed-vref is VDD (+5v)
     movwf      ADCON2
     movlw      b'00001001'     ;analog eingang controlle: pos voltage referenz
     movwf      ADCON1          ;by FVR // neg volt ref by Vref-Pin portA0
     movlw      b'10100000'     ;fix volt ref enabled //output 2.048 Volt
     movwf      VREFCON0
     clrf       LATB            ;init the latch          ; auf high=disable
     clrf       TRISB           ;port b auf ausgang
     clrf       LATC            ;init the latch by turning off everything
     clrf       TRISC           ;Configure as output
     
MainLoop:
     nop
main1:                          ;
     movlw      h'0'		;fr test d'0' in adclow und adchigh laden
     movwf      adclow          ;
     movlw      h'0'
     movwf      adchigh
     call       schwelle01      ;        
     nop
     bra	main1           ;schleife
;--------------------------------------
schwelle01:                      
     movlw       h'f4'          ; bit mit dez 500 laden; h'1f4'
     movwf       bitlow         ; bit low mit dez 244 = h'f4'
     movlw       h'1'           ; bit high mit dez '1'
     movwf       bithigh
                                ;bit minus adc, ort fr ergebnis egal
schwell012:                      
     nop
     movf       adclow,0,1      ;bitlow minus adclow
     subwf      bitlow,0,1      ;ergebnis in wreg
     bn         blinken         ;ergebnis ist negativ, springen
     nop                        ;ergebnis ist positiv
     movf       adchigh,0,1     ;bithigh minus adchigh
     subwf      bithigh,0,1     ;ergebnis in wreg
     bn         blinken         ;ergebnis ist negativ, springen 
     bra        schwelle02      ;ergebnis ist positiv  
     return                     ;
blinken:                        ;ergebnis negativ
    nop
    nop
    return
schwelle02:                     ;ergebnis positiv
     nop
     nop
     return
      
     end
