
PROCESSOR 18F14K22

; PIC18F14K22 Configuration Bit Settings
; CONFIG1H
  CONFIG  FOSC = IRC            ; Oscillator Selection bits (Internal RC oscillator)
  CONFIG  PLLEN = OFF           ; 4 X PLL Enable bit (PLL is under software control)
  CONFIG  PCLKEN = ON           ; Primary Clock Enable bit (Primary clock enabled)
  CONFIG  FCMEN = OFF           ; Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor disabled)
  CONFIG  IESO = OFF            ; Internal/External Oscillator Switchover bit (Oscillator Switchover mode disabled)

; CONFIG2L
  CONFIG  PWRTEN = OFF          ; Power-up Timer Enable bit (PWRT disabled)
  CONFIG  BOREN = OFF           ; Brown-out Reset Enable bits (Brown-out Reset disabled in hardware and software)
  CONFIG  BORV = 19             ; Brown Out Reset Voltage bits (VBOR set to 1.9 V nominal)

; CONFIG2H
  CONFIG  WDTEN = OFF           ; Watchdog Timer Enable bit (WDT is controlled by SWDTEN bit of the WDTCON register)
  CONFIG  WDTPS = 32768         ; Watchdog Timer Postscale Select bits (1:32768)

; CONFIG3H
  CONFIG  HFOFST = OFF          ; HFINTOSC Fast Start-up bit (The system clock is held off until the HFINTOSC is stable.)
  CONFIG  MCLRE = ON            ; MCLR Pin Enable bit (MCLR pin enabled, RA3 input pin disabled)

; CONFIG4L
  CONFIG  STVREN = ON           ; Stack Full/Underflow Reset Enable bit (Stack full/underflow will cause Reset)
  CONFIG  LVP = ON              ; Single-Supply ICSP Enable bit (Single-Supply ICSP enabled)
  CONFIG  BBSIZ = OFF           ; Boot Block Size Select bit (1kW boot block size)
  CONFIG  XINST = OFF           ; Extended Instruction Set Enable bit (Instruction set extension and Indexed Addressing mode disabled (Legacy mode))

; CONFIG5L
  CONFIG  CP0 = OFF             ; Code Protection bit (Block 0 not code-protected)
  CONFIG  CP1 = OFF             ; Code Protection bit (Block 1 not code-protected)

; CONFIG5H
  CONFIG  CPB = OFF             ; Boot Block Code Protection bit (Boot block not code-protected)
  CONFIG  CPD = OFF             ; Data EEPROM Code Protection bit (Data EEPROM not code-protected)

; CONFIG6L
  CONFIG  WRT0 = OFF            ; Write Protection bit (Block 0 not write-protected)
  CONFIG  WRT1 = OFF            ; Write Protection bit (Block 1 not write-protected)

; CONFIG6H
  CONFIG  WRTC = OFF            ; Configuration Register Write Protection bit (Configuration registers not write-protected)
  CONFIG  WRTB = OFF            ; Boot Block Write Protection bit (Boot block not write-protected)
  CONFIG  WRTD = OFF            ; Data EEPROM Write Protection bit (Data EEPROM not write-protected)

; CONFIG7L
  CONFIG  EBTR0 = OFF           ; Table Read Protection bit (Block 0 not protected from table reads executed in other blocks)
  CONFIG  EBTR1 = OFF           ; Table Read Protection bit (Block 1 not protected from table reads executed in other blocks)

; CONFIG7H
  CONFIG  EBTRB = OFF           ; Boot Block Table Read Protection bit (Boot block not protected from table reads executed in other blocks)

#include <xc.inc>

PSECT udata_acs
adcL:		DS  1   ;variable fr daten aus analog-eingang
adcH:		DS  1
hunderter:      DS  1   ; fr decode
zehner:         DS  1
einer:          DS  1	; auch fuer temp!

PSECT resetVec,class=CODE,reloc=2
resetVec:
    goto    main

PSECT code
main:
    movlw   00000010B	    ;set cpu clock speed of 31KHz
    movwf   OSCCON,A        ;move contents of working register into OSCCON
    clrf    OSCTUNE,A       ;
    clrf    LATA,A
    clrf    TRISA,A         ;port a ausgang
    clrf    LATB,A          ;
    clrf    TRISB,A         ;port b ausgang
    clrf    LATC,A          ;
    clrf    TRISC,A         ;port c Configure as output
    			    ; fr rechenprobe adc fllen (mit irgendwas)
_MainLoop:
    nop                     ;adc = wert nach auslesen des analogen eingangs
    movlw   0x67            ;adcL
    movwf   adcL,A          ;
    movlw   0x02            ;adcH
    movwf   adcH,A

    call    indezimal       ;zerlegen in hunderter, zehner, einer
    bra	    _MainLoop	    ;zurck zum anfang

indezimal:                  ;adc wert in dezimalstellen
                            ;  - analogmesswert in adcL & adcH
                            ;  - d'100' oder d'10' in WREG
;-------------------
_hun:                       ;hunderter stelle ermitteln
    clrf    hunderter,A
_hunLoop:                   ;
    movff   adcL,einer      ;sichern u wiederherstellen,wenn negativ war
    movlw   100             ;WREG mit h'64' = d'100' fllen
    subwf   adcL,F,A	    ;ergebnis wieder in adcL
    bc	    _hunInc	    ;wenn ergebnis positiv, hundert++
    decf    adcH,A	    ; sonst adcH--
    bnc     _hunEnd	    ;wenn adcH negativ wird, ab zu zehner und einer
_hunInc:
    incf    hunderter,A	    ;ist noch hunderter
    bra     _hunLoop	    ; weiter hunderter zhlen
_hunEnd:                    ;ausgang: hunderter in hunderter, rest in einer (temp)
    movff   einer,adcL      ;erst adcL wiederherstellen einer (temp) -> adcL
    clrf    adcH,A	    ; das aber auch !!!
;----------------
_zehn:                      ;eingang: zehner und einer
    clrf    zehner,A
_zehnLoop:
    movff   adcL,einer      ;sichern u wiederherstellen,wenn negativ war
    movlw   10              ;wieviel zehner stecken in adcL ?
    subwf   adcL,F,A        ;minus zehn, der rest in adcL
    btfss   CARRY	    ;keiner Zehner mehr?
    return		    ; fertig - Einer sind schon in einer!
    incf    zehner,A        ; sonst zehner++
    bra     _zehnLoop       ; und weiter zehner zaehlen

    END

