; PICkit 3 Starter Kit
; Assembly Lesson 1 - "Hello World"
;
; The LEDs are connected to input-outpins (I/O) RC0 through RC3. First, the I/O pin
; must be configured for an output. In this case, when one of these pins is driven high
; (RC0 =  1 ), the LED will turn on. These two logic levels are derived from the power pins
; of the PIC MCU. Since the PIC device?s power pin (VDD) is connected to 5V and the
; source (VSS) to ground (0V), a ? 1 ? is equivalent to 5V, and a ?0 ? is 0V.
;
; This turns on DS1 LED on the Low Pin Count Demo Board.
;
; 
; VSK @THU 21.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>
  
PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:
    BANKSEL TRISC       ; select bank1
    bcf     TRISC,0     ; make IO Pin C0 an output
    BANKSEL LATC        ; select bank2
    clrf    LATC        ; init the LATCH by turning off everything
    bsf     LATC,0      ; turn on LED C0 (DS1)
    goto    $           ; sit here forever!

    END     resetVec