; PICkit 3 Starter Kit
; Assembly Lesson 2 - "Blink"
;
; One way to create a delay is to spend time decrementing a value. In assembly, the timing
; can be accurately programmed since the user will have direct control on how the
; code is executed. In ?C?, the compiler takes the ?C? and compiles it into assembly before
; creating the file to program to the actual PIC MCU (HEX file). Because of this, it is hard
; to predict exactly how many instructions it takes for a line of ?C? to execute.
;
; DS1 blinks at a rate of approximately 1.5 seconds.
;
;
; VSK @THU 21.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>

GLOBAL Delay1,Delay2;make this global so it is watchable when debugging
PSECT udata_shr     ;shared memory location that is accessible from all banks
Delay1:
    DS      1       ;reserve 1 byte for Delay1
Delay2:
    DS      1       ;reserve 1 byte for Delay2

    ; -------------------LATC-----------------
    ; Bit#:  -7---6---5---4---3---2---1---0---
    ; LED:   ---------------|DS4|DS3|DS2|DS1|-
    ; ----------------------------------------


PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:
    BANKSEL OSCCON
    movlw   00111000B   ;set cpu clock speed of 500KHz ->correlates to (1/(500K/4)) for each instruction
    movwf   OSCCON
    BANKSEL TRISC       ; select bank1
    bcf     TRISC,0     ; make IO Pin C0 an output
    BANKSEL LATC        ; select bank2
    clrf    LATC        ; init the LATCH by turning off everything

MainLoop:
    bsf     LATC, 0     ; turn LED on

OndelayLoop:
    decfsz  Delay1,f    ; Waste time.
    bra     OndelayLoop ; The Inner loop takes 3 instructions per loop * 256 loops = 768 instructions
    decfsz  Delay2,f    ; The outer loop takes an additional 3 instructions per lap * 256 loops
    bra     OndelayLoop ; (768+3) * 256 = 197376 instructions / 125K instructions per second = 1.579 ;sec.

    bcf     LATC,0      ; Turn off LED C0 - NOTE: do not need to switch banks with 'banksel' since ;bank2 is still selected

OffDelayLoop:
    decfsz  Delay1,f    ; same delay as above
    bra     OffDelayLoop
    decfsz  Delay2,f
    bra     OffDelayLoop
    bra     MainLoop    ; Do it again...

    END     resetVec
