; PICkit 3 Starter Kit
; Assembly Lesson 9 - Timer0
;
; Timer0 is a counter implemented in the processor. It may be used to count instruction
; cycles or external events, that occur at or below the instruction cycle rate.
; In the PIC18, Timer0 can be used as either an 8-bit or 16-bit counter, or timer. The
; enhanced mid-range core implements only an 8-bit counter.
; This lesson configures Timer0 to count instruction cycles and to set a flag when it rolls
; over. This frees up the processor to do meaningful work rather than wasting instruction
; cycles in a timing loop.
; Using a counter provides a convenient method of measuring time or delay loops as it
; allows the processor to work on other tasks rather than counting instruction cycles.
;
;
; LEDs rotate from right to left, similar to Lesson 3, at a rate of ~.5 seconds.
;
        
; VSK @THU 24.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>
    
PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:                       ;Setup main init
    BANKSEL     OSCCON          ;bank1
    movlw       00111000B       ;set cpu clock speed
    movwf       OSCCON          ;move contents of the working register into OSCCON
                                ;Configure the LEDs
    banksel     TRISC           ;bank1
    clrf        TRISC           ;make all of PORTC an output
    banksel     LATC            ;bank2
    movlw       00001000B       ;start with DS4 lit
    movwf       LATC

                                ;Setup Timer0
    banksel     OPTION_REG      ;bank1
    movlw       00000111B       ;1:256 prescaler for a delay of: (insruction-cycle * 256-counts)*prescaler = ((8uS * 256)*256) =~ 524mS
    movwf       OPTION_REG

MainLoop:
    btfss       TMR0IF          ;did TMR0 roll over yet?
    bra         $-1             ;wait until TMR0 overflows and sets TMR0IF
    bcf         TMR0IF          ;must clear flag in software

                                ;rotate the LEDs
    banksel     LATC            ;bank2
    lsrf        LATC, f
    btfsc       CARRY           ;did the bit rotate into the carry?
    bsf         LATC,3          ;yes, put light DS4 back up

    bra         MainLoop        ;continue forever

    END     resetVec