; PICkit 3 Starter Kit
; Assembly Lesson 3 - "Rotate"
;
; This lesson will introduce shifting instructions as well as bit-oriented
; skip operations to move the LED display.
;
; LEDs rotate from right to left at a rate of 1.5s
;
;
; VSK @THU 22.11.2022
; MPLABX v6.00 / pic-as v2.40
; Board: PICkit 3 Low Pin Count Demo Board
; *******************************************************************
; * See Low Pin Count Demo Board User's Guide for Lesson Information*
; *******************************************************************

// config statements in Config_16F1829.s
#include <xc.inc>

GLOBAL Delay1,Delay2;make them global -> watchable when debugging
PSECT udata_shr     ;shared memory location that is accessible from all banks
Delay1:
    DS      1       ;reserve 1 byte for Delay1
Delay2:
    DS      1       ;reserve 1 byte for Delay2

    ; -------------------LATC-----------------
    ; Bit#:  -7---6---5---4---3---2---1---0---
    ; LED:   ---------------|DS4|DS3|DS2|DS1|-
    ; ----------------------------------------

PSECT resetVec,class=CODE,delta=2   ; define "-presetVec=0h" in custom linker options
resetVec:
     BANKSEL        OSCCON          ;bank1
     movlw          00111000B       ;set cpu clock speed of 500KHz
     movwf          OSCCON          ;move contents of the working register into OSCCON
     clrf           TRISC           ;make all of PORTC an output
     BANKSEL        LATC            ;select the bank where LATC is (bank2)
     movlw          00001000B       ;start the rotation by setting DS4 ON
     movwf          LATC            ;write contents of the working register to the latch
MainLoop:
OndelayLoop:
     decfsz         Delay1,f        ;Waste time.
     goto           OndelayLoop     ;The Inner loop takes 3 instructions per loop * 256 loopss = 768 instructions
     decfsz         Delay2,f        ;The outer loop takes an additional 3 instructions per lap * 256 loops
     goto           OndelayLoop     ;(768+3) * 256 = 197376 instructions / 125K instructions per second = 1.579 sec.

Rotate:
    lsrf            LATC,F          ;shift the LEDs and turn on the next LED to the right
    btfsc           CARRY           ;did the bit rotate into the carry (i.e. was DS1 just lit?)
    bsf             LATC, 3         ;yes, it did and now start the sequence over again by turning on DS4
    goto            MainLoop        ;repeat this program forever

    END     resetVec
    