
#include "ds18b20_2.h"
#include "inttypes.h"

#pragma udata

//extern void tmr3Us(byte us);
//extern	void ftoa(float f,char *buf);
extern void ausg8b(uint8_t byte);
//extern char s1[81]; //="12345678901234567890";
//extern char stringf[21];
//char_10	sn="";

BYTE mr_byte;

#pragma code

//////////////////////////////////////////////////////////////////////////////
// OW_RESET - performs a reset on the one-wire bus and
// returns the presence detect. Reset is 480us, so delay
// value is (480-24)/16 = 28.5 - we use 29. Presence checked
// another 70us later, so delay is (70-24)/16 = 2.875 - we use 3.3
//*/
unsigned char ow_reset(void)
{
	unsigned char presence;
	
	CLR_GIEH;
	outp_owp = 0;
    tris_owp = 0;    //pull tris_owp line low

//>480us

	wait_100us(2);	//(250);	//_ff orginal 500us (>480us)
	wait_100us(3);	//tmr3Us(250);

	tris_owp = 1;
//	outp_owp =1; //291012

//	SleepUs(70); //strut 72 (15-60us wartet DS bis presence kommt)
	wait_1us(64);	//tmr3Us(70); 
	presence = inp_owp; //liegt jetzt 60us-240us an

//Gesamtwartezeit nach tris=1 >480us
	SET_GIEH;
	wait_10us(23);	//tmr3Us(230);
	wait_10us(20);	//tmr3Us(200);
//	SleepUs(230);//strut 424us --480-62 minimum 480-40
//	SleepUs(200);

	return(presence);
} // 0=presence, 1 = no part




//////////////////////////////////////////////////////////////////////////////
// READ_BIT - reads a bit from the one-wire bus. The delay
// required for a read is 15us, so the DELAY routine won't work.
// We put our own delay function in this routine in the form of a
// for() loop.
//*/

unsigned char read_bit(void)
{
	unsigned char i;
	CLR_GIEH;
    outp_owp = 0;
	tris_owp = 0; // pull tris_owp low to start timeslot

//>1us warten
	wait_1us(2);	//tmr3Us(1);
	tris_owp = 1; // 

//>15us warten, anschl 45us daten da (Typ nach 15us)
	wait_1us(16);	//_ff original 20us
//	SleepUs(20); // delay 15us from start of timeslot //ff 15 strut 12
	i = inp_owp; //45us daten da

// Gesamtzeit 2*>1us +>15us +>45us = gesamt 60us-120us warten
	SET_GIEH;
	wait_1us(48);	//(40); //mindestens 45us warten  -- wird in read_byte erledigt --_ff original 50us 18.02.18 46us
	return(i); // return value of tris_owp line

}

/////////////////////////////////////////////////////////////////////////////
// WRITE_BIT - writes a bit to the one-wire bus, passed in bitval.
//*/
void write_bit(char bitval)
{
	CLR_GIEH;
    outp_owp = 0;
	tris_owp = 0; // pull tris_owp low to start timeslot

	if(bitval==1) 
	{
		wait_1us(2);	//tmr3Us(1); //>=1us
		tris_owp =1; // return tris_owp high if write 1
	}	

	//60-120us Gesamtlaufzeit
	wait_1us(90);	//_ff original 80us	//62us 050218
	tris_owp =1;
	//SET_GIEH; //unten falls sich tris im Interrupt ndert

	wait_1us(2);	//tmr3Us(1);// >=1us hight am Ende
    SET_GIEH;

}// Delay provides 16us per loop, plus 24us. Therefore delay(5) = 104us


//////////////////////////////////////////////////////////////////////////////
// READ_BYTE - reads a byte from the one-wire bus.
//*/
unsigned char read_byte(void)
{
	unsigned char i;
	unsigned char value = 0;

//	value =0;

	for (i=0;i<8;i++)
	{

        value >>= 1;    
        if (read_bit())  
          value |= 128;  

//		SleepUs(105); //strut 105  --in read_bit erledigt

	}
	return(value);
}


//////////////////////////////////////////////////////////////////////////////
// WRITE_BYTE - writes a byte to the one-wire bus.
//*/
void write_byte(char val)
{
	unsigned char i;
	unsigned char temp;

  for (i=0; i<8; i++) // writes byte, one bit at a time
  {
	temp = val >> i; 
	temp &= 0x01;
	write_bit(temp);
  }
	wait_1us(90);	//_ff eingefgt 050218
//	SleepUs(105); //ff 80 //105 strut 105  --1 us mindestwartezeit in write_bit enth.
}


///////////////////////////////////////////////////////////////////
// Reading the temperature
//*/

/*
char* Read_Temperature(char *sn,char* get)
{
//char get[10];
char *sr1[8];
int k;

unsigned char c;
//char *send; char *send2;

	ow_sn(0); //0 nicht sn, damit skipt (alle convertiert werden)
//	while((read_byte()==0xff));
	write_byte(Convert_T);
//SleepMs_800;
	SleepMs(250);	//750ms -480ms (von Reset) = 270ms
	SleepMs(250);
	SleepMs(255);

	ow_sn(sn);

	Read_ScratchPad(get);

 //get[0]=0x7b;get[1]=1;	//23.6875 C
//	f_4toa(get,*sr1);
	float4li(get,*sr1);	
	return *sr1;
}
*/


void ow_sn(char* sn1)
{
	ow_reset();

	//if (!*sn1) write_byte(Skip_Rom);
	//else
	{
		write_byte(Match_Rom);
		writeln_ow(sn1);
	}

}

void writeln_ow(char* sn)
{
int i;
	for (i=0;i<8;i++)	
	{	
		write_byte(sn[i]);	
	}
}


//////////////////////////////////////////////
// Reading from Scratch Pad
//////////////////////////////////////////////

void Read_ScratchPad(char* pad)
{
int j;
//char pad[10];
		write_byte(0xBE);
			for (j=0;j<9;j++){pad[j]=read_byte();}
}



void Read_ROM(char* dat)
{
	int n;
//	static char dat[9];

	ow_reset();
	write_byte(0x33);
	for (n=0;n<8;n++)
	{
		dat[n]=read_byte();
//		ausg8b(dat[n]);
	}

}
