#include "delays.h"

#if defined(BOARD_V1) | defined(BOARD_JS)
#define CLOCK_RATE 16000000L
#elif defined(BOARD_V2)
#define CLOCK_RATE 40000000L
#else
#error "Kein Board konfiguriert (siehe README.TXT)!!"
#endif

//1TCY = 0,1us bei 40MHz
#define wait_10ms(t)  Delay10KTCYx(CLOCK_RATE / 4 * t / 1000 / 1000)	//10	= 100000TCY		(1..25)FF	
#define wait_1ms(t)   Delay1KTCYx (CLOCK_RATE / 4 * t / 1000 / 1000)	//10	= 10000TCY		(1..25)
#define wait_100us(t) Delay100TCYx(CLOCK_RATE / 4 * t / 1000 / 1000)	//10	= 1000TCY		(1..25)
//#define wait_10us(t)  Delay100TCYx(CLOCK_RATE / 4 * t / 1000 / 10000)	//1		= 100TCY		(1..255)FF 
#define wait_10us(t)  Delay10TCYx (CLOCK_RATE / 4 * t / 1000 / 1000)	//10	= 100TCY		(1..25)JS 
#define wait_1us(t)   Delay10TCYx (CLOCK_RATE / 4 * t / 1000 / 10000)	//1 	= 10TCY			(1..255)

#define EMS_BAUD_RATE  9600
#define EMS_BAUD_RATE2  8571
// 64 bei BRGH = 0; 16 bei BRGH = 1
#define UART_K 64
#define UART_DIVISOR (unsigned char)(CLOCK_RATE / UART_K / EMS_BAUD_RATE) - 1
#define UART_DIVISOR2 (unsigned char)(CLOCK_RATE / UART_K / EMS_BAUD_RATE2) - 1


/*
 * Belegung der Ports
 */
#define IN  1
#define OUT 0

/*********************** LED *************************/
//LATAbits.LATA0 blau
//LATAbits.LATA1 orange

#define initLedPort()	TRISAbits.RA0 = IN; TRISAbits.RA1 = IN; LATAbits.LATA0 = 0; LATAbits.LATA1=0
#define LED_bl		TRISAbits.RA0	//darf nur ber TRISA geschaltet werden, wegen angeschl. Taster 
#define LED_or		TRISAbits.RA1	//darf nur ber TRISA geschaltet werden, wegen angeschl. Taster 

#if defined(BOARD_JS)
#define LED_ACT		TRISAbits.RA0
#define LED_USB		TRISAbits.RA0
#define LED_ON          1
#define LED_OFF         0
#else
//#define LED_ACT		LATAbits.LATA0
//#define LED_USB		LATAbits.LATA1

#define LED_RX		TRISAbits.RA0 //_ff jetzt RX und TX (Internetverbindung)
#define LED_TX		TRISAbits.RA1 //_ff
#define LED_ON          0
#define LED_OFF         1
#endif

/*********************** Analog-Mode-Sel *************/
#define MODE_SEL	LATAbits.LATA5

/*********************** PS2/OneWire *****************/
#if defined(BOARD_V1) | defined(BOARD_V2)
#define PS2_DATA	LATBbits.LATB0
#define PS2_CLK		LATBbits.LATB1
#endif

/*********************** CAN *************************/
#define initCanPort()	TRISBbits.RB3 = IN; \\
                        TRISBbits.RB2 = OUT;

#define CAN_RXD		LATBbits.LATB3	// input
#define CAN_TXD		LATBbits.LATB2	// output

/*********************** LCD *************************/
#define initLCDPort()	LATCbits.LATC0 = 1; \\
                        LATCbits.LATC1 = 1; \\
                        LATCbits.LATC2 = 0; \\
						LATAbits.LATA2 = 0; \\
                        TRISCbits.RC0 = OUT; \\
                        TRISCbits.RC1 = OUT; \\
	                    TRISCbits.RC2 = OUT; \\
                        TRISAbits.RA2 = OUT; 	

#define dataPortRead()	TRISD = 0xff; Nop();
#define dataPortWrite() TRISD = 0x00; Nop();

#define LCD_RS_PIN	LATCbits.LATC0  // 0-Instruction, 1- Data
#define LCD_RW_PIN	LATCbits.LATC1  // 0-Write, 1-READ
#define LCD0_E LATCbits.LATC2
#define LCD1_E LATAbits.LATA2

#define LCD_DATA_LATCH	LATD		// auch USB
#define LCD_DATA_PORT	PORTD		// auch USB

/*********************** USB *************************/
//
// PWREN, RXF, TXE sind INPUT
//
#if defined(BOARD_V1) | defined(BOARD_V2)
#define initUSBPort()	TRISAbits.RA4 = IN; \\
                        TRISBbits.RB6 = IN; \\
                        TRISBbits.RB7 = IN; \\
                        TRISEbits.RE0 = OUT; \\
                        TRISEbits.RE1 = OUT;

#define USB_PWREN	PORTAbits.RA4   // IN
#define USB_RXF		PORTBbits.RB6   // IN
#define USB_TXE		PORTBbits.RB7   // IN
#endif

#if defined (BOARD_JS)
#define initUSBPort()	TRISAbits.RA4 = IN; \\
                        TRISBbits.RB0 = IN; \\
                        TRISBbits.RB1 = IN; \\
                        TRISEbits.RE0 = OUT; \\
                        TRISEbits.RE1 = OUT;

#define USB_PWREN	PORTAbits.RA4   // IN
#define USB_RXF		PORTBbits.RB0   // IN
#define USB_TXE		PORTBbits.RB1   // IN
#endif
//
// WR = 0, RD = 1 ist inaktiv
//
#define USB_RD		LATEbits.LATE0  // OUT
#define USB_WR		LATEbits.LATE1  // OUT
#define initUSBData()   USB_RD = 1; USB_WR = 0; 

#define USB_DATA_LATCH	LATD		// auch LCD
#define USB_DATA_PORT	PORTD		// auch LCD

/*********************** EMS *************************/
#define EMS_TX		LATCbits.LATC6  // OUT
#define EMS_RX		PORTCbits.RC7   // IN

#define initEMSPort()	EMS_TX = 1; TRISCbits.RC7 = IN; TRISCbits.RC6 = OUT;
/*********************** EPROM ***********************/
#if defined(BOARD_V1) | defined(BOARD_JS)
//#define EPROM_SCL	LATCbits.LATC3
//#define EPROM_SDA	LATCbits.LATC4
#endif

/*********************** SD/MMC ***********************/
#if defined(BOARD_V2) | defined(BOARD_JS)
#define MMC_CS		LATAbits.LATA2

#define initSDPort()        MMC_CS = 1; \\
                            TRISAbits.RA2 = OUT;

//#define MMC_SCL		LATCbits.LATC3
//#define MMC_SDA		LATCbits.LATC4
//#define MMC_SDI		LATCbits.LATC5
#endif

/*********************** ETHERNET**********************/
#if defined(BOARD_V2) | defined (BOARD_JS)
#define NET_CS		LATAbits.LATA3
#define NET_RST		LATBbits.LATB4
#define NET_INT		LATBbits.LATB5

#define initETHPort()   NET_RST = 1; NET_CS = 1; TRISAbits.RA3 = OUT; TRISBbits.RB4 = OUT; TRISBbits.RB5 = IN; 

// INT ist nicht ntig
// SPI ist vorgegeben
//#define NET_SCK		LATCbits.LATC3
//#define NET_SDI		LATCbits.LATC4
//#define NET_SDO		LATCbits.LATC5
#endif
