#ifndef ds18b20_2_H
#define ds18b20_2_H

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>

#include "typedefs.h"
#include "delays.h"
#include "hardware.h"
//#include "sleep_ff.h"
//#include "sleep.h"

//#include <absacc.h> /* absolute addressing modes */
#include <ctype.h> /* character types */
#include <math.h> /* standard math */
#include <stdlib.h> /* standard I/O */
#include <string.h> /* string functions */

#include <usart.h>


/** D E F I N I T I O N S ****************************************************/


#define CLR_GIEH	mr_byte.b0 = INTCONbits.GIEH;\
					INTCONbits.GIEH =0 


#define SET_GIEH 	INTCONbits.GIEH = mr_byte.b0
/*
#define CLR_GIEH
#define SET_GIEH
*/

#define inp_owp		PORTEbits.RE2	//one_wire_pin
//#define inp_owp2	PORTAbits.RA4
#define outp_owp	LATEbits.LATE2	//PORTAbits.RA4
//#define outp_owp2	LATAbits.LATA4
#define tris_owp	TRISEbits.TRISE2	
//#define tris_owp2	TRISAbits.TRISA4
//#define Carry		STATUSbits.C

//#define SleepMs_800 SleepMs(250);SleepMs(250);SleepMs(250);SleepMs(50)

#define	Skip_Rom				0xcc
#define Alarm_Search			0xec
#define Convert_T				0x44
#define Write_Scratchpad		0x4e
#define Read_Scratchpad			0xbe
#define Copy_Scratchpad			0x48
#define Search_Rom				0xf0
#define Read_Rom				0x33
#define Match_Rom				0x55
#define Recall_EE				0xb8
#define Read_Power_Supply		0xb4


typedef	char char_10[10];


/** P U B L I C  P R O T O T Y P E S *****************************************/

unsigned char ow_reset(void);
unsigned char read_bit(void);
void write_bit(char bitval);
unsigned char read_byte(void);
void write_byte(char val);
//char* Read_Temperature(char *sn,char *get);
void ow_sn(char* sn1);
void Read_ScratchPad(char* pad);
void writeln_ow(char* sn);

void Read_ROM(char* dat);

//extern void f_4toa(char *get,char *s0);
extern void float4li(char *get, char *erg);


#endif	// ds18b20_2_H

/****  E N D E  *********************************************/
