;12.04.23 interrupt1   irq high   
;    
;PIC18F14K22 / Assembler / MPLAB X IDE v5.20 / PICkit3 Demo Board
;quarz mit 10,24 MHz // 1 TC = 2,56 MHz           
;        port a:    RA0,RA1,RA3 nc
;                   RA2 eingang fr taster, liegt mit 12 kO an Plus 
;                   RA4 quarz oszillator ausgang
;                   RA5 quarz oszillator eingang
;        port b:    RB4 bis RB7 ausgang und unbenutzt
;        port c:    RC0 grne led // irq high
;                   RC1 rote led // irq low
;                   RC3 blaue led zur allg. kontrolle    
;                   RC2,RC4 bis RC7 nc     
; 
;interrupt high level mit irq-routine "ruptus" // grne led
;------------------------
#include <p18F14K22.inc>
    ;config settings
    CONFIG IESO = OFF, PLLEN = OFF, FOSC = HS, FCMEN = OFF, PCLKEN = ON
    CONFIG BOREN = SBORDIS, BORV = 19, PWRTEN = OFF, WDTEN = OFF
    CONFIG MCLRE = ON, HFOFST = OFF, DEBUG = OFF, STVREN = ON
    CONFIG XINST = OFF, BBSIZ = OFF, LVP = OFF
    CONFIG CP0 = OFF, CP1 = OFF
    CONFIG CPD = OFF, CPB = OFF
    CONFIG WRT0 = OFF, WRT1 = OFF
    CONFIG WRTB = OFF, WRTC = OFF, WRTD = OFF
    CONFIG EBTR0 = OFF, EBTR1 = OFF
    CONFIG EBTRB = OFF

    errorlevel -302       ;surpress the 'not in bank0' warning
    
GPR_VAR         UDATA
counta          RES   1   ;uere schleife
counti          RES   1   ;innere    "
;--------------------------------
     Org    0x0000	
     bra    START
     Org    0x0008        ;vector fr high priority irq
     bra    ruptus
     
START:
     movlw  d'0000100'    ;primary oszi einschalten
     movwf  OSCCON2  
     clrf   LATA
     movlw  b'00100100'   ;port a5 eingang fr oszillator, a4 oszi-ausgang
     movwf  TRISA         ;a2 eingang taste
     movlw  b'00100000'
     movwf  ANSEL         ;a5 auf analog, die anderen auf digital
     clrf   WPUA          ;keine pull ups widerstnde an port a
     bsf    IOCA,2        ;a2 fr irq freigeben
            
     clrf   LATB          ;init the latch
     clrf   TRISB         ;port b komplett auf ausgang
                 
     clrf   LATC          ;init the latch by turning off everything
     clrf   TRISC         ;alles auf output
     
     bsf    RCON, IPEN    ;auf pic18 spezifikation: high priority irq
     clrf   INTCON        ;erstmal alles disablen
     bsf    INTCON2,RABIP ;pull-ups enabled, high priority
;-------------------------------------------------------------
Main:
     nop
schlaf:
     movf   PORTA,0       ;read-memory-write, port a nur lesen
     bcf    INTCON,RABIF
     movlw  b'10001000'   ;GIEH und RABIE fr irq freigeben
     movwf  INTCON
     nop
     sleep
     nop
;-------------------
auf:
     clrf   INTCON
lasslos:
     btfss  PORTA,2
     bra    lasslos
     call   butak31       ;tasten-loslassen entprellen  
;-------------------
fertig:                   ;einmal gesendet, jetzt wieder zum Schlummern
     bsf    LATC,3        ;dritte led an, blau
     bra    Main
;-------------------
ruptus:
    movf    PORTA,0
    bcf     INTCON,RABIF
    clrf    INTCON
    bsf     LATC,0        ;grne led zum anzeigen ein  
    retfie                ;zurck aus irq, aber den dort disabeln    
;-------------------			
butak31:                  ;
     movlw  d'250'        ;
     movwf  counta        ;  
loopa:
     movlw  d'255'        ;
     movwf  counti        ;innere  loop mit 255 d
loopi:
     decfsz counti,1      ;
     bra    loopi         ;
     decfsz counta,1      ;
     bra    loopa         ;
     return               ;
;-----------------------------------------------
     end

     
;einstellung fr irq high:
     
;1.  bsf RCON,IPEN    
;2.  bsf INTCON2,RABIP
;3.  bsf INTCON,GIE  
;4.  bsf INCTCON,RABIE  
